/**
 * Copyright (c) 2009, 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gregoire DUPE (Mia-Software) - initial API and implementation
 *     Nicolas BROS (Mia-Software)
 */
package org.eclipse.emf.facet.infra.facet.core.internal;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.facet.infra.common.core.internal.builder.AbstractEmfFacetCatalog;
import org.eclipse.emf.facet.infra.common.core.internal.builder.EmfFacetCatalogBuilder;
import org.eclipse.emf.facet.infra.facet.core.FacetSetCatalog;

public class FacetBuilder extends EmfFacetCatalogBuilder {

	protected static final String FILE_EXTENSION = "facetSet"; //$NON-NLS-1$
	private static final String MARKER_TYPE = "org.eclipse.emf.facet.infra.facet.problem"; //$NON-NLS-1$

	@Override
	protected AbstractEmfFacetCatalog getCatalog() {
		return FacetSetCatalog.getSingleton();
	}

	@Override
	protected String getElementType() {
		return Messages.FacetBuilder_facetSet;
	}

	@Override
	protected String getRegistrationExtensionPoint() {
		return FacetSetCatalog.REGISTRATION_EXTENSION_POINT_ID;
	}

	@Override
	protected String getMarkerType() {
		return FacetBuilder.MARKER_TYPE;
	}

	@Override
	protected String getFileExtension() {
		return FacetBuilder.FILE_EXTENSION;
	}

	@Override
	protected Plugin getActivator() {
		return Activator.getDefault();
	}

}
