/**
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - Bug 341514 - EMF Facet Queries have to be able to use EditingDomain
 */
package org.eclipse.emf.facet.infra.query.core;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue;

/**
 * To get a sub class instance of this class, the {@link ModelQuerySetCatalog}
 * must be used.
 * 
 * <pre>
 * ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
 * ModelQuerySet modelQuerySet = catalog.getModelQuerySet(&quot;emffacet.infra.query.tests.01&quot;);
 * ModelQuery modelQuery = modelQuerySet.getQuery(&quot;test001&quot;);
 * AbstractModelQuery modelQueryInst = catalog.getModelQueryImpl(modelQuery);
 * </pre>
 * 
 */
public abstract class AbstractModelQueryWithEditingDomain extends AbstractModelQuery {

	public AbstractModelQueryWithEditingDomain(final ModelQuery modelQuery) {
		super(modelQuery);
	}

	/**
	 * This method must be overridden by each sub class to implement query
	 * evaluation.
	 * 
	 * @param context
	 *            The query evaluation context
	 * @param parameterValues
	 *            The query parameter values
	 * @param editingDomain
	 *            The editing domain used to perform EMF Command
	 * @return A list of ModelQueryResult (one per evaluation)
	 * @throws ModelQueryExecutionException
	 */
	public abstract Object basicEvaluate(final EObject context,
			final List<ModelQueryParameterValue> parameterValues, EditingDomain editingDomain)
			throws ModelQueryException;
}
