/**
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - Bug 341514 - EMF Facet Queries have to be able to use EditingDomain
 */
package org.eclipse.emf.facet.infra.query.core.exception;

import org.eclipse.emf.edit.domain.EditingDomain;

/**
 * This exception has to be thrown whenever an {@link EditingDomain} is missing.
 */
public class EditingDomainExpectedException extends ModelQueryException {

	private static final long serialVersionUID = 6997831487733837237L;

	public EditingDomainExpectedException(final String message) {
		super(message);
	}

	public EditingDomainExpectedException(final String message, final Throwable cause) {
		super(message, cause);
	}

	public EditingDomainExpectedException(final Throwable cause) {
		super(cause);
	}

}
