/**
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Frederic MADIOT (Mia-Software) - meta-model design
 *     Gregoire DUPE (Mia-Software) - design and implementation
 * 
 *
 * $Id$
 */
package org.eclipse.emf.facet.infra.query.runtime;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.facet.infra.query.ModelQueryParameter;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Model Query Parameter Value</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue#getParameter <em>Parameter</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue#getValue <em>Value</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.emf.facet.infra.query.runtime.RuntimePackage#getModelQueryParameterValue()
 * @model
 * @generated
 */
public interface ModelQueryParameterValue extends EObject {
	/**
	 * Returns the value of the '<em><b>Parameter</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parameter</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Parameter</em>' reference.
	 * @see #setParameter(ModelQueryParameter)
	 * @see org.eclipse.emf.facet.infra.query.runtime.RuntimePackage#getModelQueryParameterValue_Parameter()
	 * @model required="true"
	 * @generated
	 */
	ModelQueryParameter getParameter();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue#getParameter <em>Parameter</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Parameter</em>' reference.
	 * @see #getParameter()
	 * @generated
	 */
	void setParameter(ModelQueryParameter value);

	/**
	 * Returns the value of the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Value</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Value</em>' attribute.
	 * @see #setValue(Object)
	 * @see org.eclipse.emf.facet.infra.query.runtime.RuntimePackage#getModelQueryParameterValue_Value()
	 * @model required="true"
	 * @generated
	 */
	Object getValue();

	/**
	 * Sets the value of the '{@link org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue#getValue <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Value</em>' attribute.
	 * @see #getValue()
	 * @generated
	 */
	void setValue(Object value);

} // ModelQueryParameterValue
