/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.infra.query.ui.filters;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryReturnTypeFilter
extends ViewerFilter {
    private final List<Class<?>> expectedReturnTypes;

    public QueryReturnTypeFilter(List<Class<?>> expectedReturnTypes) {
        this.expectedReturnTypes = expectedReturnTypes;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof ModelQuery) {
            ModelQuery modelQuery = (ModelQuery)element;
            return this.hasExpectedReturnType(modelQuery);
        }
        return true;
    }

    private boolean hasExpectedReturnType(ModelQuery modelQuery) {
        EClassifier returnType = modelQuery.getReturnType();
        if (returnType == null) {
            return this.expectedReturnTypes.isEmpty();
        }
        Class returnTypeClass = returnType.getInstanceClass();
        return this.expectedReturnTypes.contains(returnTypeClass);
    }
}

