/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.query.java.core.internal.evaluator;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.facet.efacet.Query;
import org.eclipse.emf.facet.efacet.core.exception.QueryException;
import org.eclipse.emf.facet.efacet.core.exception.QueryExecutionException;
import org.eclipse.emf.facet.efacet.core.query.IQueryEvaluator;
import org.eclipse.emf.facet.efacet.core.query.IQueryEvaluatorFactory;
import org.eclipse.emf.facet.query.java.core.IJavaQuery;
import org.eclipse.emf.facet.query.java.core.internal.evaluator.JavaQueryEvaluator;
import org.eclipse.emf.facet.query.java.core.internal.plugin.Activator;
import org.eclipse.emf.facet.query.java.javaquery.JavaQuery;
import org.eclipse.emf.facet.query.java.javaquery.JavaqueryPackage;
import org.eclipse.emf.facet.util.core.Logger;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaQueryEvaluatorFactory
implements IQueryEvaluatorFactory {
    public IQueryEvaluator create(Query query, Bundle bundle) throws QueryException {
        if (!(query instanceof JavaQuery)) {
            throw new QueryException("Wrong kind of Query: " + query.getClass().getSimpleName() + " found, " + JavaQuery.class.getSimpleName() + " expected.");
        }
        if (bundle == null) {
            throw new QueryException("Query: " + query.getClass().getSimpleName() + " should be create with a bundle.");
        }
        JavaQueryEvaluator javaQueryEvaluator = null;
        try {
            JavaQuery javaQuery = (JavaQuery)query;
            String className = javaQuery.getImplementationClassName();
            if (className == null || className.length() == 0) {
                throw new QueryExecutionException("implementationClassName is empty");
            }
            Class javaQueryClass = bundle.loadClass(className);
            if (!IJavaQuery.class.isAssignableFrom(javaQueryClass)) {
                throw new Exception(String.valueOf(className) + " does not implement " + IJavaQuery.class.getSimpleName() + ".");
            }
            javaQueryEvaluator = this.createJavaQueryImpl(javaQuery, javaQueryClass);
            javaQueryEvaluator.setCheckResultType(true);
        }
        catch (Exception e) {
            QueryException queryException = new QueryException("Failed to load the java query:" + query.getName(), (Throwable)e);
            Logger.logError((Throwable)queryException, (Plugin)Activator.getDefault());
            throw queryException;
        }
        return javaQueryEvaluator;
    }

    private JavaQueryEvaluator createJavaQueryImpl(JavaQuery javaQuery, Class<?> javaQueryClass) throws InstantiationException, IllegalAccessException {
        IJavaQuery javaQueryInst = (IJavaQuery)javaQueryClass.newInstance();
        JavaQueryEvaluator javaQueryEvaluator = new JavaQueryEvaluator((Query)javaQuery, javaQueryInst);
        return javaQueryEvaluator;
    }

    public EClass getManagedQueryType() {
        return JavaqueryPackage.eINSTANCE.getJavaQuery();
    }
}

