/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.core;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.facet.util.core.internal.Activator;

public final class Logger {
    private Logger() {
    }

    public static void logError(Throwable e, Plugin plugin) {
        Logger.log(e, 4, e.getMessage(), plugin);
    }

    public static void logError(String message, Plugin plugin) {
        Logger.log(null, 4, message, plugin);
    }

    public static void logError(Throwable e, String message, Plugin plugin) {
        Logger.log(e, 4, message, plugin);
    }

    public static void logWarning(Throwable e, Plugin plugin) {
        Logger.log(e, 2, e.getMessage(), plugin);
    }

    public static void logWarning(String message, Plugin plugin) {
        Logger.log(null, 2, message, plugin);
    }

    public static void logWarning(Throwable e, String message, Plugin plugin) {
        Logger.log(e, 2, message, plugin);
    }

    public static void logInfo(Throwable e, Plugin plugin) {
        Logger.log(e, 1, e.getMessage(), plugin);
    }

    public static void logInfo(String message, Plugin plugin) {
        Logger.log(null, 1, message, plugin);
    }

    public static void log(Throwable e, int level, String message, Plugin plugin) {
        Throwable effectiveE = e;
        Plugin effectivePlugin = plugin;
        String effectiveMessage = message;
        MultiStatus status = null;
        if (effectiveE instanceof InvocationTargetException) {
            effectiveE = ((InvocationTargetException)effectiveE).getTargetException();
        }
        if (effectivePlugin == null) {
            effectivePlugin = Activator.getDefault();
        }
        if (effectiveE instanceof CoreException) {
            MultiStatus mstatus;
            status = mstatus = new MultiStatus(plugin.getBundle().getSymbolicName(), level, new IStatus[]{((CoreException)effectiveE).getStatus()}, message, effectiveE);
        } else {
            if (effectiveMessage == null && effectiveE != null) {
                effectiveMessage = effectiveE.getMessage();
            }
            if (effectiveMessage == null && effectiveE != null) {
                effectiveMessage = effectiveE.toString();
            }
            if (effectiveMessage == null) {
                effectiveMessage = "";
            }
            try {
                effectiveMessage = String.valueOf(effectiveMessage) + " (" + effectivePlugin.getBundle().getSymbolicName() + "_" + effectivePlugin.getBundle().getVersion() + ")";
            }
            catch (NullPointerException e2) {
                effectiveMessage = String.valueOf(effectiveMessage) + " (activator class = " + effectivePlugin.getClass().getName() + ")";
            }
            if (effectiveE == null) {
                effectiveE = new LogStackTrace();
            }
            status = new Status(level, effectivePlugin.getBundle().getSymbolicName(), effectiveMessage, effectiveE);
        }
        effectivePlugin.getLog().log((IStatus)status);
    }

    protected static class LogStackTrace
    extends Exception {
        private static final long serialVersionUID = 309882934616507415L;

        protected LogStackTrace() {
        }
    }
}

