/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.util.core.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.facet.util.core.internal.FolderUtils;
import org.osgi.framework.Bundle;

public final class FileUtils {
    private FileUtils() {
    }

    public static String getFileContents(Bundle bundle, String path) throws IOException {
        URL url = bundle.getResource(path);
        if (url == null) {
            return null;
        }
        InputStream source = url.openStream();
        return FileUtils.readInputStream(source);
    }

    public static String readInputStream(InputStream stream) throws IOException {
        return FileUtils.readInputStream(stream, "UTF-8");
    }

    public static String readInputStream(InputStream stream, String charset) throws IOException {
        int read;
        int bufferSize = 65536;
        char[] buffer = new char[65536];
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(stream, charset);
        do {
            if ((read = ((Reader)reader).read(buffer, 0, buffer.length)) <= 0) continue;
            builder.append(buffer, 0, read);
        } while (read >= 0);
        ((Reader)reader).close();
        return builder.toString();
    }

    public static IFile copyFileFromBundle(String sourcePath, IProject project, String destinationPath, Bundle bundleContainingResources) throws IOException, CoreException {
        InputStream source;
        URL url = bundleContainingResources.getResource(sourcePath);
        if (url != null) {
            source = url.openStream();
        } else {
            url = bundleContainingResources.getEntry(sourcePath);
            if (url == null) {
                throw new IOException(String.valueOf(sourcePath) + " not found.");
            }
            source = url.openStream();
        }
        IFile javaFile = project.getFile(destinationPath);
        if (javaFile.exists()) {
            javaFile.delete(true, (IProgressMonitor)new NullProgressMonitor());
        }
        if (!javaFile.getParent().exists()) {
            FolderUtils.createFolder((IFolder)javaFile.getParent());
        }
        javaFile.create(source, true, (IProgressMonitor)new NullProgressMonitor());
        return javaFile;
    }
}

