/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 337442 - [NatTableWidget] CreateNewElement action is not available
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.examples.ecore.internal.query.epackage;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.emf.facet.infra.query.core.java.IJavaModelQuery;
import org.eclipse.emf.facet.infra.query.core.java.ParameterValueList;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactoriesRegistry;
import org.eclipse.emf.facet.widgets.celleditors.ICommandFactory;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethodParameters;

public class CreateEClass implements IJavaModelQuery<EPackage, EClass> {
	public EClass evaluate(final EPackage context,
			final ParameterValueList parameterValues)
			throws ModelQueryExecutionException {
		EditingDomain editingDomain = null;
		ModelQueryParameterValue model = parameterValues
				.getParameterValueByName(InstantiationMethodParameters
						.getEditingDomainParameter().getName());
		if (model != null) {
			if (model.getValue() instanceof EditingDomain) {
				editingDomain = (EditingDomain) model.getValue();
			}
		}
		if (editingDomain != null) {
			ICommandFactory commandFactory = ICommandFactoriesRegistry
					.INSTANCE.getCommandFactoryFor(editingDomain);
			if (context != null) {
				EClass eClass = EcoreFactory.eINSTANCE.createEClass();
				Command command = commandFactory.createAddCommand(
						editingDomain, context,
						EcorePackage.eINSTANCE.getEPackage_EClassifiers(),
						eClass);
				editingDomain.getCommandStack().execute(command);
				return eClass;
			}
		}
		return null;
	}
}
