/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - initial API and implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Gregoire Dupe (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 *    Gregoire Dupe (Mia-Software) - Bug 339918 - To be able to have facet columns and to be able to have a local customization
 *    Gregoire Dupe (Mia-Software) - Bug 345730 - Deleting an element in the model breaks the table
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.util.TableinstanceAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class TableinstanceItemProviderAdapterFactory extends TableinstanceAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TableinstanceItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TableInstanceItemProvider tableInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTableInstanceAdapter() {
		if (tableInstanceItemProvider == null) {
			tableInstanceItemProvider = new TableInstanceItemProvider(this);
		}

		return tableInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryTableInstanceItemProvider queryTableInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQueryTableInstanceAdapter() {
		if (queryTableInstanceItemProvider == null) {
			queryTableInstanceItemProvider = new QueryTableInstanceItemProvider(this);
		}

		return queryTableInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryColumnItemProvider queryColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createQueryColumnAdapter() {
		if (queryColumnItemProvider == null) {
			queryColumnItemProvider = new QueryColumnItemProvider(this);
		}

		return queryColumnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReferenceColumnItemProvider referenceColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ReferenceColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReferenceColumnAdapter() {
		if (referenceColumnItemProvider == null) {
			referenceColumnItemProvider = new ReferenceColumnItemProvider(this);
		}

		return referenceColumnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContextColumnItemProvider contextColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.ContextColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createContextColumnAdapter() {
		if (contextColumnItemProvider == null) {
			contextColumnItemProvider = new ContextColumnItemProvider(this);
		}

		return contextColumnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MetaClassColumnItemProvider metaClassColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMetaClassColumnAdapter() {
		if (metaClassColumnItemProvider == null) {
			metaClassColumnItemProvider = new MetaClassColumnItemProvider(this);
		}

		return metaClassColumnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeColumnItemProvider attributeColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.AttributeColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributeColumnAdapter() {
		if (attributeColumnItemProvider == null) {
			attributeColumnItemProvider = new AttributeColumnItemProvider(this);
		}

		return attributeColumnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EContainerColumnItemProvider eContainerColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEContainerColumnAdapter() {
		if (eContainerColumnItemProvider == null) {
			eContainerColumnItemProvider = new EContainerColumnItemProvider(this);
		}

		return eContainerColumnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DefaultLabelColumnItemProvider defaultLabelColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDefaultLabelColumnAdapter() {
		if (defaultLabelColumnItemProvider == null) {
			defaultLabelColumnItemProvider = new DefaultLabelColumnItemProvider(this);
		}

		return defaultLabelColumnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RowItemProvider rowItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Row}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRowAdapter() {
		if (rowItemProvider == null) {
			rowItemProvider = new RowItemProvider(this);
		}

		return rowItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FacetAttributeColumnItemProvider facetAttributeColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetAttributeColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFacetAttributeColumnAdapter() {
		if (facetAttributeColumnItemProvider == null) {
			facetAttributeColumnItemProvider = new FacetAttributeColumnItemProvider(this);
		}

		return facetAttributeColumnItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FacetReferenceColumnItemProvider facetReferenceColumnItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.FacetReferenceColumn}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFacetReferenceColumnAdapter() {
		if (facetReferenceColumnItemProvider == null) {
			facetReferenceColumnItemProvider = new FacetReferenceColumnItemProvider(this);
		}

		return facetReferenceColumnItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (tableInstanceItemProvider != null) tableInstanceItemProvider.dispose();
		if (queryTableInstanceItemProvider != null) queryTableInstanceItemProvider.dispose();
		if (queryColumnItemProvider != null) queryColumnItemProvider.dispose();
		if (referenceColumnItemProvider != null) referenceColumnItemProvider.dispose();
		if (contextColumnItemProvider != null) contextColumnItemProvider.dispose();
		if (metaClassColumnItemProvider != null) metaClassColumnItemProvider.dispose();
		if (attributeColumnItemProvider != null) attributeColumnItemProvider.dispose();
		if (eContainerColumnItemProvider != null) eContainerColumnItemProvider.dispose();
		if (defaultLabelColumnItemProvider != null) defaultLabelColumnItemProvider.dispose();
		if (rowItemProvider != null) rowItemProvider.dispose();
		if (facetAttributeColumnItemProvider != null) facetAttributeColumnItemProvider.dispose();
		if (facetReferenceColumnItemProvider != null) facetReferenceColumnItemProvider.dispose();
	}

}
