/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table - initial API and implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Gregoire Dupe (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

import org.eclipse.emf.facet.infra.query.ModelQuery;

import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;

import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Query Column</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryColumnImpl#getQuery <em>Query</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryColumnImpl#getQueryResult <em>Query Result</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class QueryColumnImpl extends ColumnImpl implements QueryColumn {
	/**
	 * The cached value of the '{@link #getQuery() <em>Query</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQuery()
	 * @generated
	 * @ordered
	 */
	protected ModelQuery query;

	/**
	 * The cached value of the '{@link #getQueryResult() <em>Query Result</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQueryResult()
	 * @generated
	 * @ordered
	 */
	protected EList<ModelQueryResult> queryResult;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryColumnImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return TableinstancePackage.Literals.QUERY_COLUMN;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelQuery getQuery() {
		if (query != null && query.eIsProxy()) {
			InternalEObject oldQuery = (InternalEObject)query;
			query = (ModelQuery)eResolveProxy(oldQuery);
			if (query != oldQuery) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, TableinstancePackage.QUERY_COLUMN__QUERY, oldQuery, query));
			}
		}
		return query;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelQuery basicGetQuery() {
		return query;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setQuery(ModelQuery newQuery) {
		ModelQuery oldQuery = query;
		query = newQuery;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, TableinstancePackage.QUERY_COLUMN__QUERY, oldQuery, query));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ModelQueryResult> getQueryResult() {
		if (queryResult == null) {
			queryResult = new EObjectResolvingEList<ModelQueryResult>(ModelQueryResult.class, this, TableinstancePackage.QUERY_COLUMN__QUERY_RESULT);
		}
		return queryResult;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case TableinstancePackage.QUERY_COLUMN__QUERY:
				if (resolve) return getQuery();
				return basicGetQuery();
			case TableinstancePackage.QUERY_COLUMN__QUERY_RESULT:
				return getQueryResult();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case TableinstancePackage.QUERY_COLUMN__QUERY:
				setQuery((ModelQuery)newValue);
				return;
			case TableinstancePackage.QUERY_COLUMN__QUERY_RESULT:
				getQueryResult().clear();
				getQueryResult().addAll((Collection<? extends ModelQueryResult>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case TableinstancePackage.QUERY_COLUMN__QUERY:
				setQuery((ModelQuery)null);
				return;
			case TableinstancePackage.QUERY_COLUMN__QUERY_RESULT:
				getQueryResult().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case TableinstancePackage.QUERY_COLUMN__QUERY:
				return query != null;
			case TableinstancePackage.QUERY_COLUMN__QUERY_RESULT:
				return queryResult != null && !queryResult.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //QueryColumnImpl
