/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table - initial API and implementation
 *    Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *    Gregoire Dupe (Mia-Software) - Bug 333015 - To be able to hide columns
 *    Gregoire Dupe (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableinstancePackage
 * @generated
 */
public class TableinstanceSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static TableinstancePackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TableinstanceSwitch() {
		if (modelPackage == null) {
			modelPackage = TableinstancePackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @parameter ePackage the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case TableinstancePackage.TABLE_INSTANCE: {
				TableInstance tableInstance = (TableInstance)theEObject;
				T result = caseTableInstance(tableInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.QUERY_TABLE_INSTANCE: {
				QueryTableInstance queryTableInstance = (QueryTableInstance)theEObject;
				T result = caseQueryTableInstance(queryTableInstance);
				if (result == null) result = caseTableInstance(queryTableInstance);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.COLUMN: {
				Column column = (Column)theEObject;
				T result = caseColumn(column);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.QUERY_COLUMN: {
				QueryColumn queryColumn = (QueryColumn)theEObject;
				T result = caseQueryColumn(queryColumn);
				if (result == null) result = caseColumn(queryColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.REFERENCE_COLUMN: {
				ReferenceColumn referenceColumn = (ReferenceColumn)theEObject;
				T result = caseReferenceColumn(referenceColumn);
				if (result == null) result = caseFeatureColumn(referenceColumn);
				if (result == null) result = caseColumn(referenceColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.CONTEXT_COLUMN: {
				ContextColumn contextColumn = (ContextColumn)theEObject;
				T result = caseContextColumn(contextColumn);
				if (result == null) result = caseColumn(contextColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.META_CLASS_COLUMN: {
				MetaClassColumn metaClassColumn = (MetaClassColumn)theEObject;
				T result = caseMetaClassColumn(metaClassColumn);
				if (result == null) result = caseColumn(metaClassColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.ATTRIBUTE_COLUMN: {
				AttributeColumn attributeColumn = (AttributeColumn)theEObject;
				T result = caseAttributeColumn(attributeColumn);
				if (result == null) result = caseFeatureColumn(attributeColumn);
				if (result == null) result = caseColumn(attributeColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.ECONTAINER_COLUMN: {
				EContainerColumn eContainerColumn = (EContainerColumn)theEObject;
				T result = caseEContainerColumn(eContainerColumn);
				if (result == null) result = caseColumn(eContainerColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.DEFAULT_LABEL_COLUMN: {
				DefaultLabelColumn defaultLabelColumn = (DefaultLabelColumn)theEObject;
				T result = caseDefaultLabelColumn(defaultLabelColumn);
				if (result == null) result = caseColumn(defaultLabelColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.FEATURE_COLUMN: {
				FeatureColumn featureColumn = (FeatureColumn)theEObject;
				T result = caseFeatureColumn(featureColumn);
				if (result == null) result = caseColumn(featureColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.ROW: {
				Row row = (Row)theEObject;
				T result = caseRow(row);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.FACET_ATTRIBUTE_COLUMN: {
				FacetAttributeColumn facetAttributeColumn = (FacetAttributeColumn)theEObject;
				T result = caseFacetAttributeColumn(facetAttributeColumn);
				if (result == null) result = caseFeatureColumn(facetAttributeColumn);
				if (result == null) result = caseColumn(facetAttributeColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.FACET_REFERENCE_COLUMN: {
				FacetReferenceColumn facetReferenceColumn = (FacetReferenceColumn)theEObject;
				T result = caseFacetReferenceColumn(facetReferenceColumn);
				if (result == null) result = caseFeatureColumn(facetReferenceColumn);
				if (result == null) result = caseColumn(facetReferenceColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case TableinstancePackage.FACET_FEATURE_COLUMN: {
				FacetFeatureColumn facetFeatureColumn = (FacetFeatureColumn)theEObject;
				T result = caseFacetFeatureColumn(facetFeatureColumn);
				if (result == null) result = caseFeatureColumn(facetFeatureColumn);
				if (result == null) result = caseColumn(facetFeatureColumn);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Table Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Table Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTableInstance(TableInstance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Table Instance</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Table Instance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryTableInstance(QueryTableInstance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseColumn(Column object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Query Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Query Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseQueryColumn(QueryColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Reference Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Reference Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReferenceColumn(ReferenceColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Context Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Context Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseContextColumn(ContextColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Meta Class Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Meta Class Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMetaClassColumn(MetaClassColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Attribute Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Attribute Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAttributeColumn(AttributeColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EContainer Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EContainer Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEContainerColumn(EContainerColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Default Label Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Default Label Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDefaultLabelColumn(DefaultLabelColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Feature Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Feature Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFeatureColumn(FeatureColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Row</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Row</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRow(Row object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Facet Attribute Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Facet Attribute Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFacetAttributeColumn(FacetAttributeColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Facet Reference Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Facet Reference Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFacetReferenceColumn(FacetReferenceColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Facet Feature Column</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Facet Feature Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseFacetFeatureColumn(FacetFeatureColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} //TableinstanceSwitch
