/**
 * Copyright (c) 2010 CEA LIST.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Gregoire Dupe (Mia-Software) - Bug 340571 - To be able have more than one localCustomization
 *   Gregoire Dupe (Mia-Software) - Bug 340572 - Wrong multiplicity in TableInstance.facets
 *   Nicolas Guyomar (Mia-Software) - Bug 340941 - Need new row and column types in the table
 */
package org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;

import org.eclipse.emf.facet.infra.facet.Facet;

import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;

import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.impl.QueryTableInstanceImpl;

import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.QueryTableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.Tableinstance2Package;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Query Table Instance2</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryTableInstance2Impl#getLocalCustomizations <em>Local Customizations</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryTableInstance2Impl#getFacets2 <em>Facets2</em>}</li>
 *   <li>{@link org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.impl.QueryTableInstance2Impl#getQueryResults2 <em>Query Results2</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class QueryTableInstance2Impl extends QueryTableInstanceImpl implements QueryTableInstance2 {
	/**
	 * The cached value of the '{@link #getLocalCustomizations() <em>Local Customizations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLocalCustomizations()
	 * @generated
	 * @ordered
	 */
	protected EList<MetamodelView> localCustomizations;

	/**
	 * The cached value of the '{@link #getFacets2() <em>Facets2</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFacets2()
	 * @generated
	 * @ordered
	 */
	protected EList<Facet> facets2;

	/**
	 * The cached value of the '{@link #getQueryResults2() <em>Query Results2</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQueryResults2()
	 * @generated
	 * @ordered
	 */
	protected EList<ModelQueryResult> queryResults2;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected QueryTableInstance2Impl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return Tableinstance2Package.Literals.QUERY_TABLE_INSTANCE2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MetamodelView> getLocalCustomizations() {
		if (localCustomizations == null) {
			localCustomizations = new EObjectContainmentEList<MetamodelView>(MetamodelView.class, this, Tableinstance2Package.QUERY_TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS);
		}
		return localCustomizations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Facet> getFacets2() {
		if (facets2 == null) {
			facets2 = new EObjectResolvingEList<Facet>(Facet.class, this, Tableinstance2Package.QUERY_TABLE_INSTANCE2__FACETS2);
		}
		return facets2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ModelQueryResult> getQueryResults2() {
		if (queryResults2 == null) {
			queryResults2 = new EObjectContainmentEList<ModelQueryResult>(ModelQueryResult.class, this, Tableinstance2Package.QUERY_TABLE_INSTANCE2__QUERY_RESULTS2);
		}
		return queryResults2;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS:
				return ((InternalEList<?>)getLocalCustomizations()).basicRemove(otherEnd, msgs);
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__QUERY_RESULTS2:
				return ((InternalEList<?>)getQueryResults2()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS:
				return getLocalCustomizations();
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__FACETS2:
				return getFacets2();
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__QUERY_RESULTS2:
				return getQueryResults2();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS:
				getLocalCustomizations().clear();
				getLocalCustomizations().addAll((Collection<? extends MetamodelView>)newValue);
				return;
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__FACETS2:
				getFacets2().clear();
				getFacets2().addAll((Collection<? extends Facet>)newValue);
				return;
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__QUERY_RESULTS2:
				getQueryResults2().clear();
				getQueryResults2().addAll((Collection<? extends ModelQueryResult>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS:
				getLocalCustomizations().clear();
				return;
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__FACETS2:
				getFacets2().clear();
				return;
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__QUERY_RESULTS2:
				getQueryResults2().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS:
				return localCustomizations != null && !localCustomizations.isEmpty();
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__FACETS2:
				return facets2 != null && !facets2.isEmpty();
			case Tableinstance2Package.QUERY_TABLE_INSTANCE2__QUERY_RESULTS2:
				return queryResults2 != null && !queryResults2.isEmpty();
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == TableInstance2.class) {
			switch (derivedFeatureID) {
				case Tableinstance2Package.QUERY_TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS: return Tableinstance2Package.TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS;
				case Tableinstance2Package.QUERY_TABLE_INSTANCE2__FACETS2: return Tableinstance2Package.TABLE_INSTANCE2__FACETS2;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == TableInstance2.class) {
			switch (baseFeatureID) {
				case Tableinstance2Package.TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS: return Tableinstance2Package.QUERY_TABLE_INSTANCE2__LOCAL_CUSTOMIZATIONS;
				case Tableinstance2Package.TABLE_INSTANCE2__FACETS2: return Tableinstance2Package.QUERY_TABLE_INSTANCE2__FACETS2;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

} //QueryTableInstance2Impl
