/*******************************************************************************
 * Copyright (c) 2011 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gregoire Dupe (Mia-Software) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 340940 - To be able to view facet attributes and facet references in a table
 *    Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *    Nicolas Guyomar (Mia-Software) - Bug 342451 - To be able to edit derived facet attributes and derived facet references in a table
 *    Nicolas Guyomar (Mia-Software) - Bug 345554 - SWTBot regression on build 303
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import java.util.List;

import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.swt.graphics.Point;

public interface INatTableWidgetInternal {
	public IColumnsToHideDialog openColumnsToHideDialog();
	public TableLabelProvider getTableLabelProvider();
	
	/**
	 * 
	 * @param table
	 *            the table
	 * @param setToTheTop
	 *            this attribute is used to know if we need to simulate the
	 *            moving of the local custom to the top of the custom stack
	 * @return the visible columns using the local customization file
	 */
	public List<Column> getVisibleColumnsUsingTheLocalCustomizations(final TableInstance2 table,
			final boolean setToTheTop);

	/**
	 * 
	 * @return the visible columns using the layer
	 */
	public List<Column> getVisibleColumnsUsingTheLayer();

	/**
	 * 
	 * @param customizationsToLoad
	 * set the list of customization to the tableInstance and register and load them in the customization engine
	 */
	public void loadCustomizations(final List<MetamodelView> customizationsToLoad);
	
	/**
 	 * return the Display relative position of a cell.
	 * @param columnPosition  the cell's column
	 * @param rowPosition the cell's row
	 * @return a {@link Point} corresponding to the cell position relatively to the Display
	 */
	public Point getCellPositionRelativeToDisplay(final int columnPosition, final int rowPosition);
	
	/**
	 * Wait for the resfresh job to finish
	 */
	public void waitForResfreshJob();
}
