/*******************************************************************************
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 331203 - table model editor - initial API and implementation
 *    Gregoire Dupe (Mia-Software) - Bug 352485 - [Table] Default height of cells is too small, leading to text truncations
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import net.sourceforge.nattable.layer.config.DefaultRowHeaderStyleConfiguration;
import net.sourceforge.nattable.painter.cell.BackgroundImagePainter;
import net.sourceforge.nattable.painter.cell.ICellPainter;
import net.sourceforge.nattable.painter.cell.TextPainter;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

/**
 * Customize the default row header style. This has to be added back to the
 * table.
 */
public class StyledRowHeaderConfiguration extends DefaultRowHeaderStyleConfiguration {

	private static final String ROW_HEADER_BG_IMAGE = "row_header_bg.png"; //$NON-NLS-1$

	public StyledRowHeaderConfiguration() {
		this.font = DefaultSizeUtils.getHeaderFont();
		Image bgImage = new Image(Display.getDefault(), getClass().getResourceAsStream(
				StyledRowHeaderConfiguration.ROW_HEADER_BG_IMAGE));
		TextPainter txtPainter = new TextPainter(false, false);
		ICellPainter bgImagePainter = new BackgroundImagePainter(txtPainter, bgImage, null);
		this.cellPainter = bgImagePainter;
	}
}
