/*****************************************************************************
 * Copyright (c) 2011 CEA LIST.
 *
 *    
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr  - Bug 335020 - Nattable widget should use the Eclipse framework - Initial API and implementation
 *  Nicolas Guyomar (Mia-Software) - Bug 335020 - Nattable widget should use the Eclipse framework - Remove Eclipse/Checkstyle warnings and added documentation
 *  Nicolas Guyomar (Mia-Software) - Bug 340940 - To be able to view facet attributes and facet references in a table
 *****************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/**
 * This tester is used to know if the current part is a
 * {@link INatTableWidgetProvider}
 * 
 * In the plugin.xml this tester is said working on selection. It's a trick to
 * force the refresh of the command which used it (Papyrus compatibility) ! In
 * reality, the interesting thing is to know if the current editor provides an
 * adapter} for {@link INatTableWidgetProvider}.
 * 
 */
public class TableTester extends PropertyTester {

	/** the properties to test */
	public static final String IS_TABLE = "isTable"; //$NON-NLS-1$

	public static final String IS_TABLE_EDITOR = "isTableEditor"; //$NON-NLS-1$
	
	public static final String IS_TABLE_VIEW = "isTableView"; //$NON-NLS-1$

	/**
	 * 
	 * @see org.eclipse.core.expressions.IPropertyTester#test(java.lang.Object,
	 *      java.lang.String, java.lang.Object[], java.lang.Object)
	 * 
	 * @return the result of the test on the given parameters
	 */
	public boolean test(final Object receiver, final String property, final Object[] args,
			final Object expectedValue) {
		if (TableTester.IS_TABLE.equals(property) && expectedValue instanceof Boolean) {
			Boolean answer = testIsTable();
			return answer.equals(expectedValue);
		}
		if (TableTester.IS_TABLE_EDITOR.equals(property) && expectedValue instanceof Boolean
				&& receiver instanceof IWorkbenchPart) {
			Boolean answer = testIsTableEditor((IWorkbenchPart) receiver);
			return answer.equals(expectedValue);
		}
		if (TableTester.IS_TABLE_VIEW.equals(property) && expectedValue instanceof Boolean
				&& receiver instanceof IWorkbenchPart) {
			Boolean answer = testIsTableView((IWorkbenchPart) receiver);
			return answer.equals(expectedValue);
		}
		return false;
	}

	/**
	 * @return true is the part is a {@link IViewPart} but not an instance of
	 *         {@link QueryTableInstance}
	 */
	private Boolean testIsTableView(final IWorkbenchPart part) {
		if (!(part instanceof IViewPart)) {
			return false;
		}

		Object adapter = part.getAdapter(INatTableWidgetProvider.class);
		if (adapter != null) {
			INatTableWidgetProvider natTableWidgetProvider = (INatTableWidgetProvider) adapter;
			if (natTableWidgetProvider.getNatTableWidget().getTableInstance() instanceof QueryTableInstance) {
				return false;
			}

		}
		return new Boolean(adapter != null);
	}

	/**
	 * Test if the provided {@link IWorkbenchPart} is an {@link IEditorPart} and
	 * has an adaptor for {@link INatTableWidgetProvider}
	 * 
	 * @param part
	 *            the part to test
	 * @return <code>true</code> if the {@link IEditorPart}provides an
	 *         adaptor for {@link INatTableWidgetProvider}
	 */
	private Boolean testIsTableEditor(final IWorkbenchPart part) {
		if (!(part instanceof IEditorPart)) {
			return false;
		}
		Object adapter = part.getAdapter(INatTableWidgetProvider.class);
		return new Boolean(adapter != null);
	}

	/**
	 * 
	 * @param receiver
	 * @return <code>true</code> if the current editor can be adapted to
	 *         {@link INatTableWidgetProvider}
	 */
	private Boolean testIsTable() {
		try {
			IWorkbenchPart activePart = PlatformUI.getWorkbench().getActiveWorkbenchWindow()
					.getActivePage().getActivePart();
			if (activePart != null) {
				Object adapter = activePart.getAdapter(INatTableWidgetProvider.class);
				return new Boolean(adapter != null);
			}
		} catch (NullPointerException e) {
			return new Boolean(false);
		}
		return new Boolean(false);
	}
}
