/*******************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Nicolas Bros (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *   Nicolas Guyomar (Mia-Software) - Bug 332998 - To be able to add a column and fill it with the result of a query
 *   Nicolas Guyomar (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 *   Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation 
 *   Nicolas Guyomar (Mia-Software) - Bug 340681 - Facet column implementation
 *   Vincent Lorenzo (CEA-LIST) - Bug 341238 - We need to be able to specify which column have to be hidden/visible using the customization mechanism
 *   Nicolas Guyomar (Mia-Software) - Bug 344918 - Bug between facets and customizations : BasicIndexOutOfBoundsException
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.internal.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.facet.infra.browser.custom.MetamodelView;
import org.eclipse.emf.facet.infra.browser.custom.ui.actions.AbstractLoadCustomizationsAction;
import org.eclipse.emf.facet.infra.browser.custom.ui.dialogs.LoadCustomizationsDialog;
import org.eclipse.emf.facet.infra.facet.Facet;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LoadCustomizationsAction extends AbstractLoadCustomizationsAction {

	private final NatTableWidget natTableWidget;

	public LoadCustomizationsAction(final NatTableWidget natTableWidget) {
		super();
		this.natTableWidget = natTableWidget;
	}

	@Override
	protected void loadCustomizations(final List<MetamodelView> selectedCustomizations) {
		this.natTableWidget.loadCustomizations(selectedCustomizations);
	}

	@Override
	protected void loadFacet(final Facet referencedFacet) {
		// nothing here
	}

	@Override
	protected void facetsLoaded(final Set<Facet> referencedFacets) {
		try {
			List<Facet> facets = new ArrayList<Facet>();
			facets.addAll(this.natTableWidget.getLoadedFacets());
			facets.addAll(referencedFacets);
			this.natTableWidget.setFacets(facets);
		} catch (CoreException e) {
			Logger.logError(e, Activator.getDefault());
			MessageDialog.openError(getShell(), "Failed to load facets", //$NON-NLS-1$
					"Some facets failed to load. See error to have more details."); //$NON-NLS-1$
			//TODO Those string have to externalized
		}
	}

	@Override
	protected Shell getShell() {
		return Display.getCurrent().getActiveShell();
	}

	@Override
	protected Collection<EPackage> getReferencedEPackages() {
		return this.natTableWidget.getReferencedEPackages();
	}

	@Override
	protected List<MetamodelView> getRegisteredCustomizations() {
		return this.natTableWidget.getTableInstance().getCustomizations();
	}

	@Override
	protected LoadCustomizationsDialog createLoadCustomizationDialog(
			final List<MetamodelView> registeredCustomizations) {
		TableInstance tableInstance = this.natTableWidget.getTableInstance();
		List<MetamodelView> localCustoms = new ArrayList<MetamodelView>();
		if (tableInstance instanceof TableInstance2) {
			localCustoms.addAll(((TableInstance2) tableInstance).getLocalCustomizations());
		}
		return new org.eclipse.emf.facet.widgets.nattable.internal.dialogs.NatTableWidgetLoadCustomizationsDialog(getShell(),
				registeredCustomizations,
				getReferencedEPackages(), localCustoms);

	}

}
