/*******************************************************************************
 * Copyright (c) 2010 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Nicolas Guyomar (Mia-Software) - Bug 332924 - To be able to save the table 
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.workbench.internal.actions;

import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

/** Action "View in Table" defined for EObject class */
public abstract class OpenTableAction implements IActionDelegate {

	private ISelection fSelection;

	public void run(final IAction action) {

		// Retrieve the editor
		IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()
				.getActiveEditor();
		IEditingDomainProvider editingDomainProvider = null;
		EditingDomain editingDomain = null;
		if (editor != null) {
			if (editor instanceof IEditingDomainProvider) {
				editingDomainProvider = (IEditingDomainProvider) editor;
				editingDomain = editingDomainProvider.getEditingDomain();
			}
		}
		if (this.fSelection instanceof IStructuredSelection) {
			final IStructuredSelection structuredSelection = (IStructuredSelection) this.fSelection;
			try {
				openOn(structuredSelection, editingDomain);
			} catch (UnsatisfiedConfigurationConstraint e) {
				MessageDialog.openWarning(null, Messages.OpenTableEditorAction_wrongEObjectType,
						Messages.OpenTableEditorAction_wrongEObjectTypeLong);
			}
		} else {
			Logger.logError("Not a structured selection", Activator.getDefault()); //$NON-NLS-1$
		}
	}

	public void selectionChanged(final IAction action, final ISelection selection) {
		this.fSelection = selection;
	}

	/**
	 * Open the Table to display the selection, if the editing is not null,
	 * model will be editable
	 * 
	 * @param structuredSelection
	 * @param editingDomain
	 * @throws UnsatisfiedConfigurationConstraint
	 */
	public abstract void openOn(final IStructuredSelection structuredSelection,
			final EditingDomain editingDomain) throws UnsatisfiedConfigurationConstraint;
}
