/*******************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Bros (Mia-Software) - Bug 331520 - view query result in NatTable - initial API and implementation
 *    Nicolas Bros (Mia-Software) - Bug 332226 - To be able to create or delete model element from the table
 *    Nicolas Guyomar (Mia-Software) - Bug 332226 - To be able to create or delete model element from the table
 *    Nicolas Guyomar (Mia-Software) - Bug 333029 - To be able to save the size of the lines and the columns
 *******************************************************************************/
package org.eclipse.emf.facet.widgets.nattable.workbench.internal.queryDisplayers;

import java.util.List;

import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.infra.query.ui.views.queryExecution.QueryResultDisplayer;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.view.NatTableView;

public class NatTableViewQueryResultDisplayer implements QueryResultDisplayer {

	public NatTableViewQueryResultDisplayer() {
		// nothing
	}

	public void displayQueryResult(final List<ModelQueryResult> result) {
		try {
			NatTableView.openOnQueryResult(result, null, null, null, null);
		} catch (UnsatisfiedConfigurationConstraint e) {
			Logger.logError(e, Activator.getDefault());
		}
	}

}
