/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor;

import java.util.EventObject;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetFactory;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.IWorkbenchPartProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor.NatTableEditorFactory;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor.TableEditorInput;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class NatTableEditor
extends EditorPart
implements ISelectionProvider,
IEditingDomainProvider,
IWorkbenchPartProvider {
    public static final String ID = "org.eclipse.emf.facet.widgets.nattable.workbench.editor.NatTableEditor";
    private TableEditorInput tableEditorInput;
    private INatTableWidget natTableWidget;
    private EditingDomain editingDomain;
    private MenuManager menuMgr;
    private final CommandStackListener commandListener = new CommandStackListener(){

        public void commandStackChanged(EventObject event) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    NatTableEditor.this.firePropertyChange(257);
                }
            });
        }
    };

    public Object getAdapter(Class adapter) {
        if (adapter == INatTableWidgetProvider.class) {
            return new INatTableWidgetProvider(){

                public INatTableWidget getNatTableWidget() {
                    return NatTableEditor.this.natTableWidget;
                }
            };
        }
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof TableEditorInput) {
            this.tableEditorInput = (TableEditorInput)input;
            this.editingDomain = this.tableEditorInput.getEditingDomain();
            this.initializeEditingDomain();
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(this.tableEditorInput);
            this.setPartName(this.tableEditorInput.getName());
        } else if (input instanceof FileEditorInput) {
            this.initializeEditingDomain();
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            URI uri = URI.createPlatformResourceURI((String)fileEditorInput.getFile().getFullPath().toString(), (boolean)true);
            if (uri != null) {
                Resource resource = null;
                if (this.getEditingDomain() != null) {
                    resource = this.getEditingDomain().loadResource(uri.toString());
                } else {
                    ResourceSetImpl rSet = new ResourceSetImpl();
                    resource = rSet.createResource(uri);
                }
                TableInstance tableInstance = null;
                for (EObject eObject : resource.getContents()) {
                    if (!(eObject instanceof TableInstance)) continue;
                    tableInstance = (TableInstance)eObject;
                    break;
                }
                this.tableEditorInput = new TableEditorInput(tableInstance, this.getEditingDomain());
                this.setSite((IWorkbenchPartSite)site);
                this.setInput(this.tableEditorInput);
                this.setPartName(fileEditorInput.getName());
            }
        } else {
            throw new PartInitException("Input should be of type TableEditorInput or a .table file");
        }
    }

    public void createPartControl(Composite parent) {
        this.menuMgr = new MenuManager("#PopUp", ID);
        this.menuMgr.add((IContributionItem)new GroupMarker("additions"));
        this.menuMgr.setRemoveAllWhenShown(true);
        Composite editorComposite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 2;
        editorComposite.setLayout((Layout)gridLayout);
        Label label = new Label(editorComposite, 0);
        label.setText(this.tableEditorInput.getDescription());
        this.natTableWidget = INatTableWidgetFactory.INSTANCE.createNatTableWidget(editorComposite, (IEditingDomainProvider)this, this.tableEditorInput.getTableInstance(), this.menuMgr);
        GridData tableGridData = new GridData();
        tableGridData.grabExcessHorizontalSpace = true;
        tableGridData.grabExcessVerticalSpace = true;
        tableGridData.horizontalAlignment = 4;
        tableGridData.verticalAlignment = 4;
        this.natTableWidget.getComposite().setLayoutData((Object)tableGridData);
        this.getSite().setSelectionProvider((ISelectionProvider)this.natTableWidget);
        this.getSite().registerContextMenu(this.menuMgr, (ISelectionProvider)this.natTableWidget);
    }

    public void setFocus() {
        this.natTableWidget.getComposite().setFocus();
    }

    public boolean isDirty() {
        return ((NatTableWidget)this.natTableWidget).usesTmpResource() || ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSave(IProgressMonitor monitor) {
        this.natTableWidget.save();
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        this.natTableWidget.saveAs();
        this.firePropertyChange(257);
    }

    protected NatTableEditorFactory getFactory() {
        return NatTableEditorFactory.getInstance();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.natTableWidget.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.natTableWidget.getSelection();
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.natTableWidget.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.natTableWidget.setSelection(selection);
    }

    protected void initializeEditingDomain() {
        if (this.editingDomain == null) {
            ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
            BasicCommandStack commandStack = new BasicCommandStack();
            this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        }
        this.editingDomain.getCommandStack().removeCommandStackListener(this.commandListener);
        this.editingDomain.getCommandStack().addCommandStackListener(this.commandListener);
    }

    public IWorkbenchPart getPart() {
        return this;
    }
}

