/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.nattable.INatTableUtils;
import org.eclipse.emf.facet.widgets.nattable.NatTableWidgetUtils;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.QueryTableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.TableInstance;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.TableConfiguration;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.UnsatisfiedConfigurationConstraint;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.Activator;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.Messages;
import org.eclipse.emf.facet.widgets.nattable.workbench.internal.editor.TableEditorInput;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NatTableEditorFactory {
    private static NatTableEditorFactory instance;

    protected NatTableEditorFactory() {
    }

    public static NatTableEditorFactory getInstance() {
        if (instance == null) {
            instance = new NatTableEditorFactory();
        }
        return instance;
    }

    public void openOn(List<EObject> elements, EditingDomain editingDomain, String description, TableConfiguration tableConfiguration, EObject context, Object parameter) throws UnsatisfiedConfigurationConstraint {
        TableInstance2 tableInstance = NatTableWidgetUtils.createTableInstance(elements, (String)description, (TableConfiguration)tableConfiguration, (EObject)context, (Object)parameter);
        this.openOn((TableInstance)tableInstance, editingDomain);
    }

    public void openOn(TableInstance input, EditingDomain editingDomain) throws UnsatisfiedConfigurationConstraint {
        if (input instanceof QueryTableInstance) {
            this.openOnQueryResult(null, (QueryTableInstance)input);
        } else {
            TableEditorInput tableEditorInput = new TableEditorInput(input, editingDomain);
            this.openOn(tableEditorInput);
        }
    }

    private void openOn(TableEditorInput input) throws UnsatisfiedConfigurationConstraint {
        if (!INatTableUtils.INSTANCE.checkInput(input.getTableInstance())) {
            throw new UnsatisfiedConfigurationConstraint();
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)activePage, (IEditorInput)input, (String)this.getEditorID(), (boolean)true);
        }
        catch (PartInitException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
    }

    protected String getEditorID() {
        return "org.eclipse.emf.facet.widgets.nattable.workbench.editor.NatTableEditor";
    }

    public void openOnQueryResult(List<ModelQueryResult> result, ModelQuery modelQuery) throws UnsatisfiedConfigurationConstraint {
        QueryTableInstance queryTableInstance = NatTableWidgetUtils.createQueryTableInstance(result, null, null, null);
        this.openOnQueryResult(modelQuery, queryTableInstance);
    }

    private void openOnQueryResult(ModelQuery modelQuery, QueryTableInstance queryTableInstance) throws UnsatisfiedConfigurationConstraint {
        String description;
        String queryName;
        int nElements = 0;
        for (ModelQueryResult mqr : queryTableInstance.getQueryResults()) {
            if (!(mqr.getValue() instanceof Collection)) continue;
            Collection collection = (Collection)mqr.getValue();
            nElements += collection.size();
        }
        if (modelQuery != null) {
            queryName = modelQuery.getName();
            description = NLS.bind((String)Messages.NatTableEditorFactory_resultsForQuery, (Object)queryName, (Object)new Integer(nElements));
        } else {
            description = nElements > 1 ? NLS.bind((String)Messages.NatTableEditorFactory_queryResults, (Object)new Integer(nElements)) : NLS.bind((String)Messages.NatTableEditorFactory_queryResult, (Object)new Integer(nElements));
            queryName = Messages.NatTableEditorFactory_aQuery;
        }
        queryTableInstance.setDescription(description);
        TableEditorInput input = new TableEditorInput((TableInstance)queryTableInstance, null){

            public String getName() {
                return queryName;
            }
        };
        this.openOn(input);
    }
}

