/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.editor.MarkerHandler;
import org.eclipse.emf.editor.MessageData;
import org.eclipse.emf.editor.ValidationInfoAdapter;
import org.eclipse.emf.editor.extxpt.ExtXptFacade;
import org.eclipse.emf.editor.extxpt.ExtXptHelper;
import org.eclipse.emf.editor.provider.ExtendedReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCheckor {
    private MarkerHandler markerHandler = new MarkerHandler();
    private ValidateAction.EclipseResourcesUtil eclipseResourcesUtil = EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE ? new ValidateAction.EclipseResourcesUtil() : null;
    private final ExtXptFacade facade;

    public ModelCheckor(ExtXptFacade facade) {
        this.facade = facade;
    }

    public List<MessageData> check(ExtendedReflectiveItemProviderAdapterFactory.ExtendedReflectiveItemProvider extendedReflectiveItemProvider, EditingDomain ed, IFile file) {
        ResourceSet toCheck = ed.getResourceSet();
        ArrayList<MessageData> messages = new ArrayList<MessageData>();
        this.markerHandler.deleteMarkers((IResource)file, (IProgressMonitor)new NullProgressMonitor());
        try {
            EList resources = toCheck.getResources();
            if (resources != null) {
                for (Resource res : resources) {
                    if (this.eclipseResourcesUtil != null) {
                        this.eclipseResourcesUtil.deleteMarkers((Object)res);
                    }
                    ValidationInfoAdapter.removeAll(res);
                    EList contents = res.getContents();
                    if (contents.isEmpty()) continue;
                    EObject rootObject = (EObject)contents.iterator().next();
                    List<MessageData> checkValidation = this.checkValidation(rootObject);
                    for (MessageData md : checkValidation) {
                        List<?> data = md.getData();
                        String location = null;
                        Iterator<?> iterator = data.iterator();
                        Object o = iterator.next();
                        if (o instanceof EObject) {
                            Object obj;
                            EObject eO = (EObject)o;
                            EStructuralFeature f = null;
                            location = extendedReflectiveItemProvider.getText(eO);
                            if (iterator.hasNext() && (obj = iterator.next()) instanceof EStructuralFeature) {
                                f = (EStructuralFeature)obj;
                                location = String.valueOf(location) + "#" + f.getName();
                            }
                            eO.eAdapters().add((Object)new ValidationInfoAdapter(md.getMessage(), f, md.getStatus()));
                        }
                        this.markerHandler.addMarker(file, md.getMessage(), md.getStatus(), location);
                    }
                    messages.addAll(checkValidation);
                    messages.addAll(this.ecoreValidation(rootObject));
                }
            }
        }
        catch (Exception e) {
            String erMes = e.getLocalizedMessage();
            if (erMes == null) {
                erMes = e.toString();
            }
            messages.add(new MessageData(":(", "An Error occured during checking: " + erMes, null, 2));
        }
        return messages;
    }

    private List<MessageData> checkValidation(EObject root) {
        MWEDiagnostic issue;
        ArrayList<MessageData> messages = new ArrayList<MessageData>();
        Issues issues = this.facade.check(root);
        MWEDiagnostic[] mWEDiagnosticArray = issues.getErrors();
        int n = mWEDiagnosticArray.length;
        int n2 = 0;
        while (n2 < n) {
            issue = mWEDiagnosticArray[n2];
            messages.add(this.createMessageFromIssue(issue, 3));
            ++n2;
        }
        mWEDiagnosticArray = issues.getWarnings();
        n = mWEDiagnosticArray.length;
        n2 = 0;
        while (n2 < n) {
            issue = mWEDiagnosticArray[n2];
            messages.add(this.createMessageFromIssue(issue, 2));
            ++n2;
        }
        return messages;
    }

    private List<MessageData> ecoreValidation(EObject rootObject) {
        int status = 1;
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(rootObject);
        switch (diagnostic.getSeverity()) {
            case 4: {
                status = 3;
                break;
            }
            case 2: {
                status = 2;
                break;
            }
            case 1: {
                status = 1;
            }
        }
        return this.createMessagesFromDiagnostic(rootObject, diagnostic, status);
    }

    private List<MessageData> createMessagesFromDiagnostic(EObject rootObject, Diagnostic diagnostic, int status) {
        ArrayList<MessageData> mds = new ArrayList<MessageData>();
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            if (this.eclipseResourcesUtil != null) {
                this.eclipseResourcesUtil.createMarkers(rootObject.eResource(), childDiagnostic);
            }
            String message = childDiagnostic.getMessage();
            MessageData md = new MessageData(childDiagnostic, message, childDiagnostic.getData(), status);
            mds.add(md);
        }
        return mds;
    }

    private MessageData createMessageFromIssue(MWEDiagnostic issue, int type) {
        String message = issue.getMessage();
        Object element = issue.getElement();
        MessageData md = new MessageData(element, message, issue.getData(), type);
        ArrayList<Object> data = new ArrayList<Object>();
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            data.add(0, element);
            EStructuralFeature feature = null;
            feature = issue.getData() != null && issue.getData().size() > 1 && String.class.isInstance(issue.getData().get(1)) ? eObject.eClass().getEStructuralFeature((String)issue.getData().get(1)) : ExtXptHelper.extractFeatureFromMessage(eObject, md);
            if (feature != null) {
                data.add(1, feature);
            }
        }
        md.setData(Collections.unmodifiableList(data));
        return md;
    }
}

