/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.DataStore;
import org.eclipse.emf.teneo.ERuntime;
import org.eclipse.emf.teneo.PackageRegistryProvider;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.TeneoException;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceMappingBuilder;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEAttribute;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.classloader.StoreClassLoadException;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerFactory;
import org.eclipse.emf.teneo.hibernate.EPackageConstructor;
import org.eclipse.emf.teneo.hibernate.HbContext;
import org.eclipse.emf.teneo.hibernate.HbHelper;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbSessionWrapper;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.HbUtil;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.hbmodel.HbAnnotatedEReference;
import org.eclipse.emf.teneo.hibernate.mapper.HibernateMappingGenerator;
import org.eclipse.emf.teneo.hibernate.mapper.MappingUtil;
import org.eclipse.emf.teneo.hibernate.mapping.econtainer.EContainerAccessor;
import org.eclipse.emf.teneo.hibernate.mapping.econtainer.EContainerFeatureIDAccessor;
import org.eclipse.emf.teneo.hibernate.mapping.econtainer.EContainerFeatureIDUserType;
import org.eclipse.emf.teneo.hibernate.mapping.econtainer.EContainerUserType;
import org.eclipse.emf.teneo.hibernate.mapping.econtainer.NewEContainerFeatureIDPropertyHandler;
import org.eclipse.emf.teneo.hibernate.mapping.elist.HibernateFeatureMapEntry;
import org.eclipse.emf.teneo.hibernate.mapping.identifier.IdentifierCacheHandler;
import org.eclipse.emf.teneo.hibernate.mapping.property.SyntheticPropertyHandler;
import org.eclipse.emf.teneo.hibernate.resource.HibernateResource;
import org.eclipse.emf.teneo.hibernate.resource.HibernateResourceFactory;
import org.eclipse.emf.teneo.hibernate.resource.HibernateXMLResourceFactory;
import org.eclipse.emf.teneo.hibernate.tuplizer.EMFEntityNameResolver;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.FetchMode;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cache.HashtableCacheProvider;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.CascadeStyle;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.MetaAttribute;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HbDataStore
implements DataStore {
    private static Log log = LogFactory.getLog(HbDataStore.class);
    private HashMap<String, List<ReferenceTo>> referers;
    private String[] topEntities;
    private List<EClass> containedEClasses;
    private String name;
    private EPackage[] ePackages;
    private EPackageConstructor ePackageConstructor = null;
    private HbContext hbContext = null;
    private PAnnotatedModel paModel = null;
    private PersistenceOptions persistenceOptions;
    private Properties properties = new Properties();
    private Interceptor interceptor;
    private String mappingXML = null;
    private ExtensionManager extensionManager;
    private EntityNameStrategy entityNameStrategy;
    private EMFEntityNameResolver entityNameResolver;
    private Map<EClass, EStructuralFeature> idFeatureByEClass = null;
    private EPackage.Registry packageRegistry = null;
    private boolean initialized = false;

    static {
        HbDataStore.initializeTypes();
    }

    private static synchronized void initializeTypes() {
        log.debug((Object)"Initializing protocol/extension for hibernate");
        Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().put("hibernate", new HibernateResourceFactory());
        Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().put("ehb", new HibernateResourceFactory());
        Resource.Factory.Registry.INSTANCE.getProtocolToFactoryMap().put("hbxml", new HibernateXMLResourceFactory());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("hibernate", new HibernateResourceFactory());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ehb", new HibernateResourceFactory());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("hbxml", new HibernateXMLResourceFactory());
    }

    public EPackage.Registry getPackageRegistry() {
        if (this.packageRegistry == null) {
            return PackageRegistryProvider.getInstance().getPackageRegistry();
        }
        return this.packageRegistry;
    }

    public void setPackageRegistry(EPackage.Registry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    public String getName() {
        return this.name;
    }

    public EPackage[] getEPackages() {
        if (this.ePackages == null && this.ePackageConstructor != null) {
            List<EPackage> ePacks = this.ePackageConstructor.getEPackages();
            EPackage[] ePacksArray = new EPackage[ePacks.size()];
            int i = 0;
            for (EPackage ePack : ePacks) {
                ePacksArray[i++] = ePack;
            }
            this.setEPackages(ePacksArray);
        }
        return this.ePackages;
    }

    private List<EClass> computeContainedEClasses() {
        EClass eClass;
        EPackage ePackage;
        ArrayList<EClass> result = new ArrayList<EClass>();
        EPackage[] ePackageArray = this.getEPackages();
        int n = ePackageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ePackage = ePackageArray[n2];
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass)) continue;
                eClass = (EClass)eClassifier;
                for (EReference eReference : eClass.getEAllReferences()) {
                    if (!eReference.isContainment() || eReference.getEReferenceType() == EcorePackage.eINSTANCE.getEObject()) continue;
                    result.add(eReference.getEReferenceType());
                }
            }
            ++n2;
        }
        ePackageArray = this.getEPackages();
        n = ePackageArray.length;
        n2 = 0;
        while (n2 < n) {
            ePackage = ePackageArray[n2];
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                if (!(eClassifier instanceof EClass) || result.contains(eClass = (EClass)eClassifier) || !this.isSuperContained(eClass, result)) continue;
                result.add(eClass);
            }
            ++n2;
        }
        return result;
    }

    private boolean isSuperContained(EClass eClass, List<EClass> containedEClass) {
        for (EClass eSuperClass : eClass.getESuperTypes()) {
            if (containedEClass.contains(eSuperClass)) {
                return true;
            }
            if (!this.isSuperContained(eSuperClass, containedEClass)) continue;
            return true;
        }
        return false;
    }

    public void setEPackages(EPackage[] epackages) {
        ArrayList<EPackage> epacks = new ArrayList<EPackage>();
        EPackage[] ePackageArray = epackages;
        int n = epackages.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage epack = ePackageArray[n2];
            this.resolveSubPackages(epack, epacks);
            ++n2;
        }
        this.ePackages = epacks.toArray(new EPackage[epacks.size()]);
    }

    private void resolveSubPackages(EPackage epack, List<EPackage> epacks) {
        if (!epacks.contains(epack)) {
            epacks.add(epack);
        }
        for (EPackage subEPackage : epack.getESubpackages()) {
            this.resolveSubPackages(subEPackage, epacks);
        }
    }

    public void setName(String name) {
        this.name = name;
        HbHelper.INSTANCE.register(this);
    }

    public String[] getTopEntities() {
        return this.topEntities;
    }

    public abstract void initialize();

    protected void initializeDataStore() {
        this.buildMappings();
        this.setInterceptor();
        log.debug((Object)"Determine referers for each class");
        this.referers = this.computeReferers();
        this.topEntities = this.computeTopEntities();
        this.containedEClasses = this.computeContainedEClasses();
        this.addContainerMappings();
        this.addExtraLazyInverseProperties();
        this.setTuplizer();
        this.setEventListeners();
        if (this.getPersistenceOptions().isUpdateSchema()) {
            log.warn((Object)"The teneo update schema option is not used anymore for hibernate, use the hibernate option: hibernate.hbm2ddl.auto");
        }
        log.debug((Object)"Registering datastore with persistent classes");
        HbHelper.INSTANCE.registerDataStoreByPC(this);
    }

    protected abstract void buildMappings();

    public abstract void close();

    public abstract Configuration getHibernateConfiguration();

    public PersistenceOptions getPersistenceOptions() {
        if (this.persistenceOptions == null) {
            Properties props = new Properties();
            InputStream in = this.getClass().getResourceAsStream("/teneo-persistence.properties");
            if (in != null) {
                try {
                    try {
                        props.load(in);
                    }
                    catch (IOException e) {
                        throw new HbMapperException(e);
                    }
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        throw new HbMapperException(e);
                    }
                }
            }
            this.persistenceOptions = (PersistenceOptions)this.getExtensionManager().getExtension(PersistenceOptions.class, new Object[]{props});
        }
        return this.persistenceOptions;
    }

    @Deprecated
    public void setPersistenceProperties(Properties persistenceOptions) {
        this.persistenceOptions = (PersistenceOptions)this.getExtensionManager().getExtension(PersistenceOptions.class, new Object[]{persistenceOptions});
    }

    @Deprecated
    public Properties getHibernateProperties() {
        return this.properties;
    }

    @Deprecated
    public Properties getPersistenceProperties() {
        return this.persistenceOptions.getProperties();
    }

    @Deprecated
    public void setHibernateProperties(Properties hibernateProperties) {
        this.properties = hibernateProperties;
    }

    public void setProperties(Properties props) {
        this.persistenceOptions = (PersistenceOptions)this.getExtensionManager().getExtension(PersistenceOptions.class, new Object[]{props});
        this.properties = props;
    }

    protected void setDefaultProperties(Properties properties) {
        String hbmUpdate;
        if (properties.getProperty("hibernate.cache.provider_class") == null) {
            log.warn((Object)("No hibernate cache provider set, using " + HashtableCacheProvider.class.getName()));
            log.warn((Object)"For production use please set the ehcache (or other) provider explicitly and configure it");
            properties.setProperty("hibernate.cache.provider_class", HashtableCacheProvider.class.getName());
        }
        if ((hbmUpdate = properties.getProperty("hibernate.hbm2ddl.auto")) == null) {
            log.info((Object)"Hibernate property: hibernate.hbm2ddl.auto not set, setting to update");
            properties.setProperty("hibernate.hbm2ddl.auto", "update");
        }
        log.debug((Object)"Setting properties in Hibernate Configuration:");
        this.logProperties(properties);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.properties);
        props.putAll((Map<?, ?>)this.getPersistenceOptions().getProperties());
        return props;
    }

    public abstract SessionFactory getSessionFactory();

    public abstract SessionWrapper createSessionWrapper();

    public HbContext getHbContext() {
        if (this.hbContext == null) {
            this.hbContext = (HbContext)this.getExtensionManager().getExtension(HbContext.class);
        }
        return this.hbContext;
    }

    public void setHbContext(HbContext hbContext) {
        hbContext.setExtensionManager(this.getExtensionManager());
        this.hbContext = hbContext;
    }

    public abstract Iterator<?> getClassMappings();

    public Object[] getCrossReferencers(Session session, Object referedTo) {
        ArrayList<Object> result = this.getCrossReferencers(new HbSessionWrapper(this, session), referedTo, false);
        return result.toArray(new Object[result.size()]);
    }

    public Object[] getCrossReferencers(SessionWrapper sessionWrapper, Object referedTo) {
        ArrayList<Object> result = this.getCrossReferencers(sessionWrapper, referedTo, false);
        return result.toArray(new Object[result.size()]);
    }

    private ArrayList<Object> getCrossReferencers(SessionWrapper sessionWrapper, Object referedTo, boolean onlyContainers) {
        assert (referedTo != null);
        String targetEntityName = null;
        if (referedTo instanceof EObject) {
            EObject eReferedTo = (EObject)referedTo;
            targetEntityName = this.getEntityNameStrategy().toEntityName(eReferedTo.eClass());
        } else if (referedTo instanceof HibernateFeatureMapEntry) {
            HibernateFeatureMapEntry fme = (HibernateFeatureMapEntry)referedTo;
            targetEntityName = fme.getEntityName();
        } else {
            throw new IllegalArgumentException("Non eobject not yet supported " + referedTo.getClass().getName());
        }
        List<ReferenceTo> refersList = this.referers.get(targetEntityName);
        if (refersList == null || refersList.size() == 0) {
            return new ArrayList<Object>();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < refersList.size()) {
            ReferenceTo refersTo = refersList.get(i);
            if (!onlyContainers || refersTo.isContainer()) {
                List<?> list = sessionWrapper.executeQuery(refersTo.getQueryStr(), "to", referedTo);
                for (Object obj : list) {
                    if (obj instanceof HibernateFeatureMapEntry) {
                        ArrayList<Object> fms = this.getCrossReferencers(sessionWrapper, obj, false);
                        if (fms.size() == 0) {
                            new AssertionError((Object)("The featuremap for featuremap entry " + obj.getClass().getName() + " can not be found"));
                        }
                        obj = fms.get(0);
                    }
                    if (result.contains(obj)) continue;
                    result.add(obj);
                }
            }
            ++i;
        }
        return result;
    }

    protected String[] computeTopEntities() {
        ArrayList<String> result = new ArrayList<String>();
        Iterator<?> pcs = this.getClassMappings();
        while (pcs.hasNext()) {
            PersistentClass pc = (PersistentClass)pcs.next();
            EClass eclass = pc.getEntityName() != null ? this.getEntityNameStrategy().toEClass(pc.getEntityName()) : EModelResolver.instance().getEClass(pc.getMappedClass());
            if (eclass == null && !pc.getEntityName().equals("EAV_EObject")) continue;
            List<ReferenceTo> refs = this.referers.get(this.getMappedName(pc));
            boolean topEntity = true;
            if (refs != null) {
                for (ReferenceTo referenceTo : refs) {
                    ReferenceTo rt = referenceTo;
                    if (!rt.isContainer) continue;
                    topEntity = false;
                    break;
                }
            }
            try {
                if (!topEntity || pc.isAbstract() != null && pc.isAbstract().booleanValue()) continue;
                result.add(this.getMappedName(pc));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                throw new TeneoException(e.getMessage(), (Throwable)e);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    protected boolean isClassOrSuperClassEAVMapped(PersistentClass pc) {
        if (pc == null) {
            return false;
        }
        if (pc.getEntityName().equals("EAV_EObject")) {
            return true;
        }
        return this.isClassOrSuperClassEAVMapped(pc.getSuperclass());
    }

    protected void addExtraLazyInverseProperties() {
        PersistentClass pc;
        HashMap<String, PersistentClass> persistentClasses = new HashMap<String, PersistentClass>();
        Iterator<?> pcs = this.getClassMappings();
        while (pcs.hasNext()) {
            pc = (PersistentClass)pcs.next();
            if (this.isClassOrSuperClassEAVMapped(pc)) continue;
            persistentClasses.put(pc.getEntityName(), pc);
        }
        pcs = this.getClassMappings();
        while (pcs.hasNext()) {
            pc = (PersistentClass)pcs.next();
            Iterator propIt = pc.getPropertyIterator();
            ArrayList<Property> props = new ArrayList<Property>();
            while (propIt.hasNext()) {
                Property prop = (Property)propIt.next();
                props.add(prop);
            }
            for (Property prop : props) {
                Join join;
                Table collectionTable;
                PersistentClass elementPC;
                EStructuralFeature ef;
                EClass eClass = null;
                if (pc.getMetaAttribute("featureMap") == null) {
                    eClass = pc.getEntityName() != null ? this.getEntityNameStrategy().toEClass(pc.getEntityName()) : EModelResolver.instance().getEClass(pc.getMappedClass());
                }
                EStructuralFeature eStructuralFeature = ef = eClass == null ? null : StoreUtil.getEStructuralFeature(eClass, (String)prop.getName());
                if (ef == null || !(ef instanceof EReference) || !(prop.getValue() instanceof org.hibernate.mapping.Collection)) continue;
                org.hibernate.mapping.Collection collection = (org.hibernate.mapping.Collection)prop.getValue();
                EReference eReference = (EReference)ef;
                if (!collection.isExtraLazy()) continue;
                Value elementValue = collection.getElement();
                if (elementValue instanceof OneToMany) {
                    OneToMany oneToMany = (OneToMany)elementValue;
                    elementPC = oneToMany.getAssociatedClass();
                } else {
                    if (!(elementValue instanceof ManyToOne)) continue;
                    ManyToOne mto = (ManyToOne)elementValue;
                    elementPC = (PersistentClass)persistentClasses.get(mto.getReferencedEntityName());
                }
                if (this.isClassOrSuperClassEAVMapped(elementPC)) continue;
                collection.setInverse(true);
                if (eReference.getEOpposite() == null) {
                    collectionTable = collection.getCollectionTable();
                    if (this.isClassOrSuperClassEAVMapped(elementPC)) continue;
                    Property inverseRefProperty = new Property();
                    inverseRefProperty.setName(StoreUtil.getExtraLazyInversePropertyName((EStructuralFeature)ef));
                    HashMap<String, MetaAttribute> metas = new HashMap<String, MetaAttribute>();
                    MetaAttribute metaAttribute = new MetaAttribute("synthetic-property");
                    metaAttribute.addValue("true");
                    metas.put("synthetic-property", metaAttribute);
                    inverseRefProperty.setMetaAttributes(metas);
                    inverseRefProperty.setNodeName(inverseRefProperty.getName());
                    inverseRefProperty.setPropertyAccessorName(SyntheticPropertyHandler.class.getName());
                    inverseRefProperty.setLazy(false);
                    ManyToOne mto = new ManyToOne(collectionTable);
                    mto.setReferencedEntityName(pc.getEntityName());
                    mto.setLazy(false);
                    mto.setFetchMode(FetchMode.SELECT);
                    inverseRefProperty.setValue((Value)mto);
                    Iterator it = collection.getKey().getColumnIterator();
                    while (it.hasNext()) {
                        Column originalColumn = (Column)it.next();
                        mto.addColumn(originalColumn);
                    }
                    mto.createForeignKey();
                    if (collectionTable.getName().equalsIgnoreCase(elementPC.getTable().getName())) {
                        elementPC.addProperty(inverseRefProperty);
                    } else {
                        join = new Join();
                        join.setPersistentClass(elementPC);
                        join.setTable(collectionTable);
                        join.addProperty(inverseRefProperty);
                        ManyToOne keyValue = new ManyToOne(collectionTable);
                        join.setKey((KeyValue)keyValue);
                        Iterator keyColumns = collection.getElement().getColumnIterator();
                        while (keyColumns.hasNext()) {
                            keyValue.addColumn((Column)keyColumns.next());
                        }
                        keyValue.setReferencedEntityName(elementPC.getEntityName());
                        keyValue.setTable(collectionTable);
                        keyValue.createForeignKey();
                        elementPC.addJoin(join);
                    }
                }
                if (!collection.isIndexed() || collection.isMap()) continue;
                collectionTable = collection.getCollectionTable();
                IndexedCollection indexedCollection = (IndexedCollection)collection;
                Column column = (Column)indexedCollection.getIndex().getColumnIterator().next();
                Property indexProperty = new Property();
                indexProperty.setName(StoreUtil.getExtraLazyInverseIndexPropertyName((EStructuralFeature)ef));
                HashMap<String, MetaAttribute> metas = new HashMap<String, MetaAttribute>();
                MetaAttribute metaAttribute = new MetaAttribute("synthetic-property");
                metaAttribute.addValue("true");
                metas.put("synthetic-property", metaAttribute);
                indexProperty.setMetaAttributes(metas);
                indexProperty.setNodeName(indexProperty.getName());
                indexProperty.setPropertyAccessorName(SyntheticPropertyHandler.class.getName());
                indexProperty.setOptional(true);
                join = null;
                Iterator it = elementPC.getJoinIterator();
                while (it.hasNext()) {
                    Join foundJoin = (Join)it.next();
                    if (!foundJoin.getTable().getName().equalsIgnoreCase(collectionTable.getName())) continue;
                    join = foundJoin;
                    collectionTable = join.getTable();
                    break;
                }
                SimpleValue sv = new SimpleValue(indexedCollection.getIndex().getTable());
                sv.setTypeName("integer");
                sv.addColumn(column);
                indexProperty.setValue((Value)sv);
                if (join != null) {
                    join.addProperty(indexProperty);
                    continue;
                }
                elementPC.addProperty(indexProperty);
            }
        }
    }

    protected void addContainerMappings() {
        if (this.getPersistenceOptions().isDisableEContainerMapping()) {
            log.debug((Object)"EContainer mapping disabled.");
            return;
        }
        Iterator<?> pcs = this.getClassMappings();
        while (pcs.hasNext()) {
            PersistentClass pc = (PersistentClass)pcs.next();
            if (HbUtil.getEClassNameFromFeatureMapMeta(pc) != null) continue;
            this.addContainerMapping(pc);
        }
    }

    protected void setTuplizer() {
        Iterator<?> pcs = this.getClassMappings();
        while (pcs.hasNext()) {
            PersistentClass pc = (PersistentClass)pcs.next();
            if (pc.getMetaAttribute("featureMap") != null) {
                pc.addTuplizer(EntityMode.MAP, this.getHbContext().getFeatureMapEntryTuplizer(this.getHibernateConfiguration()).getName());
            } else if (pc.getMetaAttribute("eclassName") != null) {
                pc.addTuplizer(EntityMode.MAP, this.getHbContext().getEMFTuplizerClass(this.getHibernateConfiguration()).getName());
                pc.addTuplizer(EntityMode.POJO, this.getHbContext().getEMFTuplizerClass(this.getHibernateConfiguration()).getName());
            } else if (pc.getMetaAttribute("eclassName") == null) continue;
            ArrayList<Property> properties = new ArrayList<Property>();
            Property identifierProperty = pc.getIdentifierProperty();
            if (identifierProperty != null) {
                properties.add(identifierProperty);
            }
            Iterator iterator = pc.getPropertyIterator();
            while (iterator.hasNext()) {
                properties.add((Property)iterator.next());
            }
            for (Object e : properties) {
                Property prop = (Property)e;
                if (prop.getName().compareTo("_identifierMapper") == 0) continue;
                Value value = prop.getValue();
                if (value instanceof Component) {
                    this.setComponentTuplizer((Component)value, this.getHibernateConfiguration());
                    continue;
                }
                if (!(value instanceof org.hibernate.mapping.Collection) || !(((org.hibernate.mapping.Collection)value).getElement() instanceof Component)) continue;
                this.setComponentTuplizer((Component)((org.hibernate.mapping.Collection)value).getElement(), this.getHibernateConfiguration());
            }
        }
    }

    protected void setEventListeners() {
    }

    protected void setComponentTuplizer(Component component, Configuration cfg) {
        EClass eClass = ERuntime.INSTANCE.getEClass(component.getComponentClass());
        if (eClass == null) {
            eClass = this.getEntityNameStrategy().toEClass(component.getComponentClassName());
        }
        if (eClass == null) {
            return;
        }
        log.debug((Object)("Found " + eClass.getName() + " as a component"));
        component.addTuplizer(EntityMode.MAP, this.getHbContext().getEMFComponentTuplizerClass(cfg).getName());
        component.addTuplizer(EntityMode.POJO, this.getHbContext().getEMFComponentTuplizerClass(cfg).getName());
        HbHelper.INSTANCE.registerDataStoreByComponent(this, component);
    }

    private boolean isContained(PersistentClass pc) {
        EClass eclass = pc.getEntityName() != null ? this.getEntityNameStrategy().toEClass(pc.getEntityName()) : EModelResolver.instance().getEClass(pc.getMappedClass());
        if (eclass == null && !pc.getEntityName().equals("EAV_EObject")) {
            return false;
        }
        if (pc.getEntityName() != null && pc.getEntityName().equals("EAV_EObject")) {
            return true;
        }
        return this.containedEClasses.contains(eclass);
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    protected abstract void setInterceptor();

    protected String mapEPackages() {
        log.debug((Object)"Generating mapping file from in-mem ecore");
        PersistenceOptions po = this.getPersistenceOptions();
        this.setPaModel(((PersistenceMappingBuilder)this.getExtensionManager().getExtension(PersistenceMappingBuilder.class)).buildMapping(this.getEPackages(), po, this.getExtensionManager()));
        HibernateMappingGenerator hmg = (HibernateMappingGenerator)this.getExtensionManager().getExtension(HibernateMappingGenerator.class);
        hmg.setPersistenceOptions(po);
        String hbm = hmg.generateToString(this.getPaModel());
        log.debug((Object)"Computing id types of mapped EClasses");
        this.idFeatureByEClass = new HashMap<EClass, EStructuralFeature>();
        this.computeIdTypesByEClass(this.idFeatureByEClass);
        return hbm;
    }

    public EClassifier getIdType(EClass eClass) {
        EStructuralFeature feature = this.getIdFeature(eClass);
        if (feature == null) {
            return XMLTypePackage.eINSTANCE.getLong();
        }
        return feature.getEType();
    }

    public Object getId(EObject eObject) {
        EStructuralFeature feature = this.getIdFeature(eObject.eClass());
        if (feature == null) {
            return IdentifierCacheHandler.getInstance().getID(eObject);
        }
        return eObject.eGet(feature);
    }

    public EStructuralFeature getIdFeature(EClass eClass) {
        return this.idFeatureByEClass.get(eClass);
    }

    protected void computeIdTypesByEClass(Map<EClass, EStructuralFeature> result) {
        for (PAnnotatedEPackage aPackage : this.getPaModel().getPaEPackages()) {
            block1: for (PAnnotatedEClass aClass : aPackage.getPaEClasses()) {
                for (PAnnotatedEStructuralFeature aFeature : aClass.getPaEStructuralFeatures()) {
                    HbAnnotatedEReference aReference;
                    PAnnotatedEAttribute aAttribute;
                    if (aFeature instanceof PAnnotatedEAttribute && (aAttribute = (PAnnotatedEAttribute)aFeature).getId() != null) {
                        result.put(aClass.getModelEClass(), aAttribute.getModelEStructuralFeature());
                        continue block1;
                    }
                    if (!(aFeature instanceof HbAnnotatedEReference) || (aReference = (HbAnnotatedEReference)aFeature).getEmbeddedId() == null) continue;
                    result.put(aClass.getModelEClass(), aReference.getModelEStructuralFeature());
                    continue block1;
                }
            }
        }
    }

    private boolean hasEContainerProp(PersistentClass pc) {
        Iterator it = pc.getPropertyIterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (!prop.getName().equals("e_container")) continue;
            return true;
        }
        if (pc.getSuperclass() == null) {
            return false;
        }
        return this.hasEContainerProp(pc.getSuperclass());
    }

    protected void addContainerMapping(PersistentClass pc) {
        if (pc.getSuperclass() != null) {
            this.addContainerMapping(pc.getSuperclass());
        }
        if (pc.getEntityName().equals("EAV_EObject") && !this.hasEContainerProp(pc)) {
            this.addContainerMappingToPC(pc);
            return;
        }
        if (!this.isContained(pc)) {
            return;
        }
        if (this.hasEContainerProp(pc)) {
            return;
        }
        log.debug((Object)("Adding container mapping for " + this.getMappedName(pc)));
        EClass eclass = pc.getEntityName() != null ? this.getEntityNameStrategy().toEClass(pc.getEntityName()) : EModelResolver.instance().getEClass(pc.getMappedClass());
        if (eclass == null || eclass.getEAnnotation("http://facet.elver.org/SkipContainerMappings") != null) {
            return;
        }
        for (EReference eref : eclass.getEAllReferences()) {
            if (!eref.isContainer()) continue;
            log.debug((Object)"There are container ereferences present, assuming that no separate econtainer columns are required.");
            return;
        }
        this.addContainerMappingToPC(pc);
    }

    protected void addContainerMappingToPC(PersistentClass pc) {
        Column ecfColumn;
        SimpleValue svfid;
        Property ecFID;
        log.debug((Object)("Adding eContainer and econtainerfeatureid properties to " + pc.getClassName()));
        PersistenceOptions.EContainerFeaturePersistenceStrategy featurePersistenceStrategy = this.getPersistenceOptions().getEContainerFeaturePersistenceStrategy();
        Property eContainer = new Property();
        eContainer.setName("e_container");
        eContainer.setMetaAttributes(new HashMap());
        eContainer.setNodeName(eContainer.getName());
        eContainer.setPropertyAccessorName(EContainerAccessor.class.getName());
        SimpleValue sv = new SimpleValue(pc.getTable());
        sv.setTypeName(EContainerUserType.class.getName());
        Column eccColumn = new Column(String.valueOf(this.getPersistenceOptions().getSQLColumnNamePrefix()) + this.getPersistenceOptions().getEContainerClassColumn());
        sv.addColumn(this.checkColumnExists(pc.getTable(), eccColumn));
        Column ecColumn = new Column(String.valueOf(this.getPersistenceOptions().getSQLColumnNamePrefix()) + this.getPersistenceOptions().getEContainerColumn());
        sv.addColumn(this.checkColumnExists(pc.getTable(), ecColumn));
        eContainer.setValue((Value)sv);
        pc.addProperty(eContainer);
        if (featurePersistenceStrategy.equals((Object)PersistenceOptions.EContainerFeaturePersistenceStrategy.FEATUREID) || featurePersistenceStrategy.equals((Object)PersistenceOptions.EContainerFeaturePersistenceStrategy.BOTH)) {
            ecFID = new Property();
            ecFID.setName("e_container_featureid");
            ecFID.setMetaAttributes(new HashMap());
            ecFID.setNodeName(ecFID.getName());
            ecFID.setPropertyAccessorName(EContainerFeatureIDAccessor.class.getName());
            svfid = new SimpleValue(pc.getTable());
            svfid.setTypeName("integer");
            ecfColumn = new Column(String.valueOf(this.getPersistenceOptions().getSQLColumnNamePrefix()) + "e_container_featureid");
            svfid.addColumn(this.checkColumnExists(pc.getTable(), ecfColumn));
            ecFID.setValue((Value)svfid);
            pc.addProperty(ecFID);
        }
        if (featurePersistenceStrategy.equals((Object)PersistenceOptions.EContainerFeaturePersistenceStrategy.FEATURENAME) || featurePersistenceStrategy.equals((Object)PersistenceOptions.EContainerFeaturePersistenceStrategy.BOTH)) {
            ecFID = new Property();
            ecFID.setName("e_container_featurename");
            ecFID.setMetaAttributes(new HashMap());
            ecFID.setNodeName(ecFID.getName());
            ecFID.setPropertyAccessorName(NewEContainerFeatureIDPropertyHandler.class.getName());
            svfid = new SimpleValue(pc.getTable());
            svfid.setTypeName(EContainerFeatureIDUserType.class.getName());
            ecfColumn = new Column(String.valueOf(this.getPersistenceOptions().getSQLColumnNamePrefix()) + this.getPersistenceOptions().getEContainerFeatureNameColumn());
            ecfColumn.setLength(this.getEContainerFeatureNameColumnLength());
            svfid.addColumn(this.checkColumnExists(pc.getTable(), ecfColumn));
            ecFID.setValue((Value)svfid);
            pc.addProperty(ecFID);
        }
    }

    protected int getEContainerFeatureNameColumnLength() {
        return 255;
    }

    private Column checkColumnExists(Table table, Column searchCol) {
        int i = 0;
        while (i < table.getColumnSpan()) {
            Column column = table.getColumn(i);
            if (this.stripQuotes(column.getName()).equalsIgnoreCase(searchCol.getName())) {
                return column;
            }
            ++i;
        }
        table.addColumn(searchCol);
        return searchCol;
    }

    private String stripQuotes(String name) {
        if (name == null) {
            return "";
        }
        return name.replaceAll("`", "").replaceAll("\"", "");
    }

    public boolean isContainedObject(Object obj) {
        throw new UnsupportedOperationException("Operation is not supported");
    }

    public void importDataStore(InputStream is, int importFormat) {
        Object importResource = importFormat == 0 ? new XMLResourceImpl() : new XMIResourceImpl();
        HibernateResource hibResource = new HibernateResource(URI.createFileURI((String)("." + this.name)));
        try {
            importResource.load(is, Collections.EMPTY_MAP);
            hibResource.getContents().addAll((Collection)importResource.getContents());
            hibResource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new HbMapperException("Exception when importing " + this.name, e);
        }
    }

    public void exportDataStore(OutputStream os, int exportFormat, String encoding) {
        HibernateResource hibResource = new HibernateResource(URI.createFileURI((String)("teneo." + this.name)));
        hibResource.load(Collections.EMPTY_MAP);
        try {
            Object exportResource = exportFormat == 0 ? new XMLResourceImpl() : new XMIResourceImpl();
            exportResource.getContents().addAll((Collection)hibResource.getContents());
            HashMap<String, String> options = new HashMap<String, String>();
            if (encoding != null) {
                options.put("ENCODING", encoding);
            }
            exportResource.save(os, options);
            hibResource.unload();
        }
        catch (IOException e) {
            throw new HbMapperException("Exception when exporting " + this.name, e);
        }
    }

    protected HashMap<String, List<ReferenceTo>> computeReferers() {
        HashMap<String, List<ReferenceTo>> result = new HashMap<String, List<ReferenceTo>>();
        Iterator<?> it = this.getClassMappings();
        ArrayList<String> fmes = new ArrayList<String>();
        while (it.hasNext()) {
            PersistentClass pc = (PersistentClass)it.next();
            if (pc.getMetaAttribute("featureMap") != null) {
                fmes.add(this.getMappedName(pc));
            }
            if (result.get(this.getMappedName(pc)) == null) {
                result.put(this.getMappedName(pc), new ArrayList());
            }
            Iterator propIt = pc.getPropertyIterator();
            while (propIt.hasNext()) {
                Property prop = (Property)propIt.next();
                EClass eClass = null;
                if (pc.getMetaAttribute("featureMap") == null) {
                    eClass = pc.getEntityName() != null ? this.getEntityNameStrategy().toEClass(pc.getEntityName()) : EModelResolver.instance().getEClass(pc.getMappedClass());
                }
                EStructuralFeature ef = eClass == null ? null : StoreUtil.getEStructuralFeature(eClass, (String)prop.getName());
                try {
                    String toEntity = "";
                    boolean isContainer = false;
                    boolean isMany = false;
                    if (prop.getValue() instanceof ManyToOne) {
                        ManyToOne mto = (ManyToOne)prop.getValue();
                        toEntity = mto.getReferencedEntityName();
                        isContainer = ef != null ? ef instanceof EReference && ((EReference)ef).isContainment() : prop.getCascadeStyle().hasOrphanDelete() || prop.getCascade().compareTo("all") == 0;
                    } else if (prop.getValue() instanceof OneToOne) {
                        OneToOne oto = (OneToOne)prop.getValue();
                        toEntity = oto.getReferencedEntityName();
                        isContainer = ef != null ? ef instanceof EReference && ((EReference)ef).isContainment() : prop.getCascadeStyle().hasOrphanDelete() || prop.getCascadeStyle() == CascadeStyle.ALL;
                    } else {
                        if (!(prop.getValue() instanceof org.hibernate.mapping.Collection)) continue;
                        isMany = true;
                        if (ef == null) {
                            org.hibernate.mapping.Collection coll;
                            boolean bl = isContainer = prop.getCascadeStyle().hasOrphanDelete() || prop.getCascadeStyle() == CascadeStyle.ALL;
                            if (((org.hibernate.mapping.Collection)prop.getValue()).getElement() instanceof OneToMany) {
                                coll = (org.hibernate.mapping.Collection)prop.getValue();
                                toEntity = ((OneToMany)coll.getElement()).getReferencedEntityName();
                            } else {
                                if (!(((org.hibernate.mapping.Collection)prop.getValue()).getElement() instanceof ManyToOne)) continue;
                                coll = (org.hibernate.mapping.Collection)prop.getValue();
                                toEntity = ((ManyToOne)coll.getElement()).getReferencedEntityName();
                            }
                        } else if (ef instanceof EAttribute && ((EAttribute)ef).getEType().getInstanceClass() == FeatureMap.Entry.class) {
                            isContainer = true;
                            if (!(((org.hibernate.mapping.Collection)prop.getValue()).getElement() instanceof OneToMany)) continue;
                            OneToMany otm = (OneToMany)((org.hibernate.mapping.Collection)prop.getValue()).getElement();
                            toEntity = otm.getReferencedEntityName();
                        } else if (ef instanceof EReference) {
                            EReference er = (EReference)ef;
                            isContainer = er.isContainment();
                            toEntity = this.getEntityNameStrategy().toEntityName(((EReference)ef).getEReferenceType());
                        } else {
                            if (!(ef instanceof EAttribute) || !(ef.getEType() instanceof EClass)) continue;
                            isContainer = true;
                            toEntity = this.getEntityNameStrategy().toEntityName((EClass)ef.getEType());
                        }
                    }
                    List<ReferenceTo> list = result.get(toEntity);
                    if (list == null) {
                        list = new ArrayList<ReferenceTo>();
                        result.put(toEntity, list);
                    }
                    list.add(new ReferenceTo(this.getMappedName(pc), prop, isContainer, isMany, toEntity));
                }
                catch (StoreClassLoadException e) {
                    throw new HbMapperException("Class not found using property: " + prop.getName() + " of " + prop, e);
                }
            }
        }
        ArrayList<EClass> classDone = new ArrayList<EClass>();
        for (String em : result.keySet()) {
            if (fmes.contains(em)) continue;
            this.setRefersToOfSupers(em, result, classDone);
        }
        return result;
    }

    private String getMappedName(PersistentClass pc) {
        if (pc.getEntityName() != null) {
            return pc.getEntityName();
        }
        return pc.getClassName();
    }

    private List<ReferenceTo> setRefersToOfSupers(String eClassUri, HashMap<String, List<ReferenceTo>> refersTo, ArrayList<EClass> classDone) {
        EntityNameStrategy ens = this.getEntityNameStrategy();
        EClass eclass = ens.toEClass(eClassUri);
        if (eclass == null) {
            return new ArrayList<ReferenceTo>();
        }
        if (classDone.contains(eclass)) {
            return refersTo.get(eClassUri);
        }
        List<ReferenceTo> thisList = refersTo.get(ens.toEntityName(eclass));
        if (thisList == null) {
            return new ArrayList<ReferenceTo>();
        }
        for (EClass class1 : eclass.getESuperTypes()) {
            String eclassUri = ens.toEntityName(class1);
            this.addUnique(thisList, this.setRefersToOfSupers(eclassUri, refersTo, classDone));
        }
        classDone.add(eclass);
        return thisList;
    }

    private void addUnique(List<ReferenceTo> l1, List<ReferenceTo> l2) {
        if (l2 == null) {
            return;
        }
        for (ReferenceTo obj : l2) {
            if (l1.contains(obj)) continue;
            l1.add(obj);
        }
    }

    protected void logProperties(Properties props) {
        for (String string : props.keySet()) {
            log.info((Object)(String.valueOf(string) + ": " + props.get(string)));
        }
    }

    protected String[] getMappingFileList() {
        if (this.getPersistenceOptions().getMappingFilePath() != null) {
            log.debug((Object)("Using specified list of mapping files " + this.getPersistenceOptions().getMappingFilePath()));
            return this.getPersistenceOptions().getMappingFilePath().split(",");
        }
        if (this.getPersistenceOptions().isUseMappingFile()) {
            EModelResolver.instance().register(this.getEPackages());
            log.debug((Object)"Searching hbm files in class paths of epackages");
            return StoreUtil.getFileList((String)"hibernate.hbm.xml", null);
        }
        throw new HbStoreException("This method may only be called if either the useMappingFile property or the MappingFilePath property has been set");
    }

    public String getMappingXML() {
        return this.mappingXML;
    }

    public void setMappingXML(String mappingXML) {
        this.mappingXML = mappingXML;
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public EntityNameResolver getEntityNameResolver() {
        if (this.entityNameResolver == null) {
            this.entityNameResolver = (EMFEntityNameResolver)this.getExtensionManager().getExtension(EMFEntityNameResolver.class);
            this.entityNameResolver.setQualifyStrategy(this.getEntityNameStrategy());
        }
        return this.entityNameResolver;
    }

    public PersistentClass getPersistentClass(String entityName) {
        Iterator<?> it = this.getClassMappings();
        while (it.hasNext()) {
            PersistentClass pc = (PersistentClass)it.next();
            if (pc.getEntityName() == null || !pc.getEntityName().equals(entityName)) continue;
            return pc;
        }
        return null;
    }

    public void setInterceptor(Interceptor interceptor) {
        this.interceptor = interceptor;
    }

    public PAnnotatedModel getPaModel() {
        if (this.paModel == null) {
            this.paModel = ((PersistenceMappingBuilder)this.getExtensionManager().getExtension(PersistenceMappingBuilder.class)).buildMapping(this.getEPackages(), this.getPersistenceOptions(), this.getExtensionManager());
        }
        return this.paModel;
    }

    public HashMap<String, List<ReferenceTo>> getReferers() {
        return this.referers;
    }

    public ExtensionManager getExtensionManager() {
        if (this.extensionManager == null) {
            this.setExtensionManager(ExtensionManagerFactory.getInstance().create());
        }
        return this.extensionManager;
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
        MappingUtil.registerHbExtensions((ExtensionManager)extensionManager);
    }

    public EntityNameStrategy getEntityNameStrategy() {
        if (this.entityNameStrategy == null) {
            this.entityNameStrategy = (EntityNameStrategy)this.getExtensionManager().getExtension(EntityNameStrategy.class);
            this.entityNameStrategy.setPaModel(this.getPaModel());
        }
        return this.entityNameStrategy;
    }

    public void setPaModel(PAnnotatedModel paModel) {
        this.paModel = paModel;
    }

    public void setEPackageClasses(List<String> ePackageClasses) {
        if (this.ePackageConstructor == null) {
            this.ePackageConstructor = new EPackageConstructor();
        }
        this.ePackageConstructor.setModelClasses(ePackageClasses);
    }

    public void setEPackageFiles(List<String> ePackageFiles) {
        if (this.ePackageConstructor == null) {
            this.ePackageConstructor = new EPackageConstructor();
        }
        this.ePackageConstructor.setModelFiles(ePackageFiles);
    }

    protected String processEAVMapping(InputStream inputStream) {
        try {
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            char[] chars = new char[500];
            int readNum = 0;
            StringBuilder sb = new StringBuilder();
            while ((readNum = reader.read(chars, 0, 500)) > 0) {
                sb.append(chars, 0, readNum);
            }
            String eav = sb.toString();
            eav = eav.replaceAll("\\{tableprefix\\}", this.getPersistenceOptions().getSQLTableNamePrefix());
            boolean extraLazy = this.getPersistenceOptions().isFetchAssociationExtraLazy();
            eav = eav.replaceAll("\\{collectionLazySetting\\}", extraLazy ? "extra" : "false");
            return eav;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class ReferenceTo {
        private final boolean isContainer;
        private final String qryStr;

        public ReferenceTo(String fromEntity, Property prop, boolean isContainer, boolean isMany, String toEntity) {
            this.isContainer = isContainer;
            this.qryStr = isMany ? "SELECT ref FROM " + fromEntity + " as ref, " + toEntity + " as refTo WHERE refTo = :to and refTo in elements(ref." + prop.getName() + ")" : "SELECT ref FROM " + fromEntity + " as ref WHERE :to = ref." + prop.getName();
        }

        public boolean isContainer() {
            return this.isContainer;
        }

        public String getQueryStr() {
            return this.qryStr;
        }
    }
}

