/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.epf.common.preferences.IPreferenceStoreWrapper;
import org.eclipse.epf.common.preferences.IPropertyChangeEventWrapper;
import org.eclipse.epf.common.preferences.IPropertyChangeListenerWrapper;
import org.eclipse.epf.common.ui.PropertyChangeEventWrapper;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PreferenceStoreWrapper
implements IPreferenceStoreWrapper {
    private IPreferenceStore store;
    Map<IPropertyChangeListenerWrapper, IPropertyChangeListener> listenerMap = new HashMap<IPropertyChangeListenerWrapper, IPropertyChangeListener>();

    public PreferenceStoreWrapper(IPreferenceStore store) {
        this.store = store;
    }

    public IPreferenceStore getStore() {
        return this.store;
    }

    public void addPropertyChangeListener(final IPropertyChangeListenerWrapper listener) {
        IPropertyChangeListener pcl = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEventWrapper wrapper = new PropertyChangeEventWrapper(event);
                listener.propertyChange((IPropertyChangeEventWrapper)wrapper);
            }
        };
        this.listenerMap.put(listener, pcl);
        this.store.addPropertyChangeListener(pcl);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        this.store.firePropertyChangeEvent(name, oldValue, newValue);
    }

    public void removePropertyChangeListener(IPropertyChangeListenerWrapper listener) {
        IPropertyChangeListener pcl = this.listenerMap.remove(listener);
        if (pcl != null) {
            this.store.removePropertyChangeListener(pcl);
        }
    }

    public boolean getBoolean(String name) {
        return this.store.getBoolean(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.store.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.store.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.store.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.store.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.store.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.store.getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.store.getDouble(name);
    }

    public float getFloat(String name) {
        return this.store.getFloat(name);
    }

    public int getInt(String name) {
        return this.store.getInt(name);
    }

    public long getLong(String name) {
        return this.store.getLong(name);
    }

    public String getString(String name) {
        return this.store.getString(name);
    }

    public boolean isDefault(String name) {
        return this.store.isDefault(name);
    }

    public boolean needsSaving() {
        return this.store.needsSaving();
    }

    public void putValue(String name, String value) {
        this.store.putValue(name, value);
    }

    public void setDefault(String name, double value) {
        this.store.setDefault(name, value);
    }

    public void setDefault(String name, float value) {
        this.store.setDefault(name, value);
    }

    public void setDefault(String name, int value) {
        this.store.setDefault(name, value);
    }

    public void setDefault(String name, long value) {
        this.store.setDefault(name, value);
    }

    public void setDefault(String name, String defaultObject) {
        this.store.setDefault(name, defaultObject);
    }

    public void setDefault(String name, boolean value) {
        this.store.setDefault(name, value);
    }

    public void setToDefault(String name) {
        this.store.setToDefault(name);
    }

    public void setValue(String name, double value) {
        this.store.setValue(name, value);
    }

    public void setValue(String name, float value) {
        this.store.setValue(name, value);
    }

    public void setValue(String name, int value) {
        this.store.setValue(name, value);
    }

    public void setValue(String name, long value) {
        this.store.setValue(name, value);
    }

    public void setValue(String name, String value) {
        this.store.setValue(name, value);
    }

    public void setValue(String name, boolean value) {
        this.store.setValue(name, value);
    }
}

