/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.ui.util;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.IActivator;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.common.ui.util.ErrorDialogNoReason;
import org.eclipse.epf.common.ui.util.WrappedMessageDialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MsgDialog {
    private String pluginId;
    private Logger logger;

    public MsgDialog(IActivator plugin) {
        this.pluginId = plugin.getId();
        this.logger = plugin.getLogger();
    }

    protected Shell getShell() {
        return PlatformUI.getWorkbench().getDisplay().getActiveShell();
    }

    public void displayError(String title, String msg) {
        this.display(4, title, msg, null, null, null);
    }

    public void displayError(String title, String msg, Throwable ex) {
        this.display(4, title, msg, null, null, ex);
    }

    public void displayError(String title, String msg, String reason) {
        this.display(4, title, msg, reason, null, null);
    }

    public void displayError(String title, String msg, String reason, Throwable ex) {
        this.display(4, title, msg, reason, null, ex);
    }

    public void displayError(String title, String msg, String reason, String details) {
        this.display(4, title, msg, reason, details, null);
    }

    public void displayError(String title, String msg, String reason, String details, Throwable ex) {
        this.display(4, title, msg, reason, details, ex);
    }

    public int displayError(String title, IStatus status) {
        return this.display(title, null, status);
    }

    public int displayError(String title, String msg, IStatus status) {
        return this.display(title, msg, status);
    }

    public void displayWarning(String title, String msg) {
        this.display(2, title, msg, null, null, null);
    }

    public void displayWarning(String title, String msg, Throwable ex) {
        this.display(2, title, msg, null, null, ex);
    }

    public void displayWarning(String title, String msg, String reason) {
        this.display(2, title, msg, reason, null, null);
    }

    public void displayWarning(String title, String msg, String reason, Throwable ex) {
        this.display(2, title, msg, reason, null, ex);
    }

    public void displayWarning(String title, String msg, String reason, String details) {
        this.display(2, title, msg, reason, details, null);
    }

    public void displayWarning(String title, String msg, String reason, String details, Throwable ex) {
        this.display(2, title, msg, reason, details, ex);
    }

    public void displayWarning(String title, IStatus status) {
        this.display(title, null, status);
    }

    public void displayWarning(String title, String msg, IStatus status) {
        this.display(title, msg, status);
    }

    public synchronized void display(int severity, String title, String msg, String reason, String details, Throwable ex) {
        if (msg == null && ex != null) {
            msg = ex.getMessage();
        }
        if (msg == null) {
            msg = "";
        }
        if (severity != 4 && severity != 2) {
            throw new IllegalArgumentException("severity argument must be IStatus.ERROR or IStatus.WARNING");
        }
        this.logger.logMsg(severity, msg, ex);
        Image oldImage = ErrorDialog.getDefaultImage();
        Image shellImage = this.getShellImage();
        if (shellImage != null) {
            ErrorDialog.setDefaultImage((Image)shellImage);
        }
        Shell shell = this.getShell();
        if (details != null && details.length() > 0) {
            MultiStatus mStatus = new MultiStatus(this.pluginId, 0, reason, ex);
            Status status = new Status(severity, this.pluginId, 0, details, ex);
            mStatus.add((IStatus)status);
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)mStatus);
        } else if (reason != null && reason.length() > 0) {
            Status status = new Status(severity, this.pluginId, 0, reason, ex);
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)status);
        } else if (severity == 4) {
            WrappedMessageDialog.openError(shell, title, msg);
        } else if (severity == 2) {
            WrappedMessageDialog.openWarning(shell, title, msg);
        }
        if (shellImage != null) {
            ErrorDialog.setDefaultImage((Image)oldImage);
        }
    }

    public synchronized int display(String title, IStatus status) {
        return this.display(title, null, status);
    }

    public synchronized int display(String title, String msg, IStatus status) {
        int severity;
        if (status == null) {
            throw new IllegalArgumentException("status argument cannot be null");
        }
        if (msg == null) {
            msg = status.getMessage();
        }
        if (msg == null) {
            msg = "";
        }
        if ((severity = status.getSeverity()) == 4 || severity == 2) {
            this.logger.logMsg(severity, msg, status.getException());
        }
        Image oldImage = ErrorDialog.getDefaultImage();
        Image shellImage = this.getShellImage();
        if (shellImage != null) {
            ErrorDialog.setDefaultImage((Image)shellImage);
        }
        Shell shell = this.getShell();
        int rc = ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)status);
        if (shellImage != null) {
            ErrorDialog.setDefaultImage((Image)oldImage);
        }
        return rc;
    }

    public void displayInfo(String title, String msg) {
        if (msg == null) {
            msg = "";
        }
        Image oldImage = WrappedMessageDialog.getDefaultImage();
        Image shellImage = this.getShellImage();
        if (shellImage != null) {
            WrappedMessageDialog.setDefaultImage((Image)shellImage);
        }
        Shell shell = this.getShell();
        WrappedMessageDialog.openInformation(shell, title, msg);
        if (shellImage != null) {
            WrappedMessageDialog.setDefaultImage((Image)oldImage);
        }
    }

    public boolean displayPrompt(String title, String msg) {
        if (msg == null) {
            msg = "";
        }
        Image oldImage = WrappedMessageDialog.getDefaultImage();
        Image shellImage = this.getShellImage();
        if (shellImage != null) {
            WrappedMessageDialog.setDefaultImage((Image)shellImage);
        }
        Shell shell = this.getShell();
        boolean result = WrappedMessageDialog.openQuestion(shell, title, msg);
        if (shellImage != null) {
            WrappedMessageDialog.setDefaultImage((Image)oldImage);
        }
        return result;
    }

    public boolean displayConfirmation(String title, String msg) {
        return this.displayConfirmationWithCheckBox(title, msg, null) > 0;
    }

    public int displayConfirmationWithCheckBox(String title, String msg, String checkBoxLabel) {
        if (msg == null) {
            msg = "";
        }
        Image oldImage = WrappedMessageDialog.getDefaultImage();
        Image shellImage = this.getShellImage();
        if (shellImage != null) {
            WrappedMessageDialog.setDefaultImage((Image)shellImage);
        }
        Shell shell = this.getShell();
        if (shellImage != null) {
            WrappedMessageDialog.setDefaultImage((Image)oldImage);
        }
        if (checkBoxLabel == null) {
            boolean b = WrappedMessageDialog.openConfirm(shell, title, msg);
            return b ? 1 : 0;
        }
        return WrappedMessageDialog.openConfirmWithCheckBox(shell, title, msg, checkBoxLabel);
    }

    public int displayConfirmation(String title, String msg, IStatus status) {
        Image shellImage;
        if (status == null) {
            throw new IllegalArgumentException("status argument cannot be null");
        }
        if (msg == null) {
            msg = status.getMessage();
        }
        if (msg == null) {
            msg = "";
        }
        if ((shellImage = this.getShellImage()) != null) {
            ErrorDialogNoReason.setDefaultImage((Image)shellImage);
        }
        Shell shell = this.getShell();
        int rc = ErrorDialogNoReason.openError(shell, title, msg, status);
        return rc;
    }

    private Image getShellImage() {
        Shell shell;
        IWorkbenchWindow workbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (shell = workbenchWindow.getShell()) != null) {
            return shell.getImage();
        }
        return null;
    }
}

