/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.ui.util;

import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class PerspectiveUtil {
    private PerspectiveUtil() {
    }

    public static String getActivePerspectiveId() {
        if (PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            return null;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            IPerspectiveDescriptor activePerspective = activePage.getPerspective();
            return activePerspective.getId();
        }
        return null;
    }

    public static IPerspectiveDescriptor openPerspective(String perspectiveId) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
            IPerspectiveDescriptor oldPerspective = activePage.getPerspective();
            if (!oldPerspective.getId().equals(perspectiveId)) {
                IPerspectiveDescriptor perspective = registry.findPerspectiveWithId(perspectiveId);
                activePage.setPerspective(perspective);
            }
            return oldPerspective;
        }
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            PlatformUI.getWorkbench().showPerspective(perspectiveId, activeWindow);
        }
        catch (WorkbenchException workbenchException) {}
        return null;
    }

    public static boolean isActivePerspective(String perspectiveId) {
        String activePerspectiveId = PerspectiveUtil.getActivePerspectiveId();
        if (perspectiveId == null || activePerspectiveId == null) {
            return false;
        }
        return activePerspectiveId.equalsIgnoreCase(perspectiveId);
    }

    public static IViewPart getView(String viewId) {
        try {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage != null) {
                IViewPart view = activePage.findView(viewId);
                if (view == null) {
                    view = activePage.showView(viewId);
                }
                return view;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

