/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.internal.ui;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Messages;
import org.eclipse.gmt.modisco.workflow.WorkflowController;
import org.eclipse.gmt.modisco.workflow.WorkflowModel;
import org.eclipse.gmt.modisco.workflow.WorkflowModelEvents;
import org.eclipse.gmt.modisco.workflow.internal.engine.WorkflowControllerImpl;
import org.eclipse.gmt.modisco.workflow.internal.engine.WorkflowModelImpl;
import org.eclipse.gmt.modisco.workflow.internal.ui.AdditionalButtonsComposite;
import org.eclipse.gmt.modisco.workflow.internal.ui.ContextualMenuInWorkflowTable;
import org.eclipse.gmt.modisco.workflow.internal.ui.wizard.WizardToSelectLaunchers;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

@Deprecated
public class WorkflowTab
extends AbstractLaunchConfigurationTab
implements WorkflowModelEvents {
    private Table transformationsTable;
    private ContextualMenuInWorkflowTable popUp;
    private WorkflowModel workflowModel;
    private final WorkflowController workflowController;
    private boolean isValid;

    public WorkflowTab() {
        this.initWorkflowModel();
        this.workflowController = new WorkflowControllerImpl();
    }

    final WorkflowModel getWorkflowModel() {
        return this.workflowModel;
    }

    public void createControl(Composite parent) {
        Composite rootContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        rootContainer.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label labelWFTransfo = new Label(rootContainer, 0);
        labelWFTransfo.setText(Messages.WorkflowTab_basicLabel);
        GridData gdLabel = new GridData();
        gdLabel.horizontalSpan = 3;
        labelWFTransfo.setLayoutData((Object)gdLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.transformationsTable = new Table(rootContainer, 2560);
        this.transformationsTable.setLayoutData((Object)gridData);
        this.transformationsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent evt) {
                if (evt.button == 3) {
                    WorkflowTab.this.contextualMenuOfTransformationTable(evt);
                }
            }
        });
        this.transformationsTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    WorkflowTab.this.removeAdditionalWork();
                }
            }
        });
        AdditionalButtonsComposite gpButtonTransformation = new AdditionalButtonsComposite(rootContainer, 0, this);
        this.setControl((Control)rootContainer);
    }

    private final void contextualMenuOfTransformationTable(MouseEvent evt) {
        Point p = new Point(evt.x, evt.y);
        TableItem item = this.getTransformationsTable().getItem(p);
        if (item == null) {
            this.getPopUp().createPopupMenuNoSelectionItem(this.getShell());
            this.getTransformationsTable().setMenu(this.getPopUp().getMenuNoSelection());
        } else {
            this.getPopUp().createPopupMenuSelectionItem(this.getShell());
            this.getTransformationsTable().setMenu(this.getPopUp().getMenuSelection());
        }
    }

    public ContextualMenuInWorkflowTable getPopUp() {
        if (this.popUp == null) {
            this.popUp = new ContextualMenuInWorkflowTable(this);
        }
        return this.popUp;
    }

    public Table getTransformationsTable() {
        return this.transformationsTable;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.initWorkflowModel();
        this.workflowModel.initialization(configuration);
        this.updateStatus();
    }

    private final void initWorkflowModel() {
        if (this.workflowModel != null) {
            this.workflowModel.unsubscribe(this);
            this.getTransformationsTable().removeAll();
        }
        this.workflowModel = new WorkflowModelImpl();
        this.workflowModel.subscribe(this);
    }

    private final void updateStatus() {
        this.setMessage(Messages.WorkflowTab_basicLabel);
        this.isValid = true;
        String errorMessage = this.workflowController.validate(this.workflowModel);
        if (errorMessage != null) {
            this.isValid = false;
        }
        this.setErrorMessage(errorMessage);
        this.updateLaunchConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.workflowModel.save(configuration);
    }

    public String getName() {
        return Messages.WorkflowTab_name;
    }

    public void notifyElementAdded(Element element) {
        this.createItemTable(element.getName(), element.getType());
        this.refreshTable();
        this.updateStatus();
    }

    private final void createItemTable(String name, String driverType) {
        this.createItemTable(name, driverType, this.getTransformationsTable().getItemCount());
    }

    private final void createItemTable(String name, String driverType, int index) {
        TableItem item = new TableItem(this.getTransformationsTable(), 0, index);
        item.setText(name);
        item.setImage(DebugUITools.getImage((String)driverType));
    }

    private final void refreshTable() {
        this.getTransformationsTable().notifyListeners(13, null);
    }

    public void notifyElementInserted(int index, Element element) {
        this.getTransformationsTable().remove(index);
        this.createItemTable(element.getName(), element.getType(), index);
        this.getTransformationsTable().select(index);
        this.refreshTable();
        this.updateStatus();
    }

    public void notifyElementRemoved(int index) {
        this.getTransformationsTable().remove(index);
        this.refreshTable();
        this.updateStatus();
    }

    public Image getImage() {
        return Activator.getImageDescriptor("icons/modiscoWorkflow.png").createImage();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.isValid;
    }

    public void loadAdditionalWork() {
        WizardToSelectLaunchers wizard = new WizardToSelectLaunchers(this.workflowModel);
        WizardDialog dialog = new WizardDialog(PlatformUI.createDisplay().getActiveShell(), (IWizard)wizard);
        dialog.setPageSize(400, 200);
        dialog.open();
    }

    public void removeAdditionalWork() {
        int index = this.getTransformationsTable().getSelectionIndex();
        if (index != -1) {
            this.workflowModel.removeElement(index);
        }
    }

    public void upAdditionalWork() {
        int index = this.getTransformationsTable().getSelectionIndex();
        if (index > 0 && index != -1) {
            this.workflowModel.upElement(index);
        }
    }

    public void downAdditionalWork() {
        int index = this.getTransformationsTable().getSelectionIndex();
        if (index + 1 < this.getTransformationsTable().getItemCount() && index != -1) {
            this.workflowModel.downElement(index);
        }
    }
}

