/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.export.batik;

import java.awt.Graphics2D;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.export.batik.GraphicsToGraphics2DAdaptor;
import org.eclipse.graphiti.ui.internal.util.ui.print.IDiagramsExporter;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGExporter
implements IDiagramsExporter {
    public void export(Image im, IFigure figure, String fileName, Double scaleFactor) throws Exception {
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument(svgNS, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        ctx.setEmbeddedFontsOn(true);
        SVGGraphics2D svgGenerator = new SVGGraphics2D(document);
        Rectangle bounds = new Rectangle(0, 0, figure.getBounds().width, figure.getBounds().height);
        GraphicsToGraphics2DAdaptor graphicsAdaptor = new GraphicsToGraphics2DAdaptor((Graphics2D)svgGenerator, bounds);
        figure.paint((Graphics)graphicsAdaptor);
        boolean useCSS = false;
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "UTF-8");
        svgGenerator.stream((Writer)out, useCSS);
    }
}

