/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.pattern;

import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IConnectionContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddConnectionContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.PictogramLink;
import org.eclipse.graphiti.pattern.AbstractBasePattern;
import org.eclipse.graphiti.pattern.IConnectionPattern;
import org.eclipse.graphiti.pattern.mapping.IStructureMapping;
import org.eclipse.graphiti.pattern.mapping.data.IDataMapping;
import org.eclipse.graphiti.pattern.mapping.data.ITextDataMapping;

public abstract class AbstractConnectionPattern
extends AbstractBasePattern
implements IConnectionPattern {
    protected static AddConnectionContext getAddConnectionContext(ICreateConnectionContext context) {
        AddConnectionContext result = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
        return result;
    }

    public boolean canCreate(ICreateConnectionContext context) {
        return false;
    }

    public boolean canStartConnection(ICreateConnectionContext context) {
        return false;
    }

    public Connection create(ICreateConnectionContext context) {
        return null;
    }

    protected Connection addGraphicalRepresentation(IConnectionContext context, Object newObject) {
        AddConnectionContext newContext = new AddConnectionContext(context.getSourceAnchor(), context.getTargetAnchor());
        newContext.setNewObject(newObject);
        return (Connection)this.getFeatureProvider().addIfPossible((IAddContext)newContext);
    }

    protected String getText(IStructureMapping structureMapping, PictogramLink link) {
        String ret = null;
        IDataMapping dm = structureMapping.getDataMapping();
        if (dm instanceof ITextDataMapping) {
            ret = ((ITextDataMapping)dm).getText(link);
        }
        return ret;
    }

    protected void layoutPictogramElement(PictogramElement pe) {
        LayoutContext context = new LayoutContext(pe);
        this.getFeatureProvider().layoutIfPossible((ILayoutContext)context);
    }

    protected void updatePictogramElement(PictogramElement pe) {
        UpdateContext context = new UpdateContext(pe);
        this.getFeatureProvider().updateIfPossible((IUpdateContext)context);
        this.layoutPictogramElement(pe);
    }

    public String getCreateDescription() {
        return null;
    }

    public String getCreateImageId() {
        return null;
    }

    public String getCreateLargeImageId() {
        return this.getCreateImageId();
    }

    public String getCreateName() {
        return null;
    }
}

