/*******************************************************************************
 * <copyright>
 *
 * Copyright (c) 2005, 2010 SAP AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SAP AG - initial API, implementation and documentation
 *
 * </copyright>
 *
 *******************************************************************************/
package org.eclipse.graphiti.internal.features.context.impl.base;

import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;

/**
 * The Class DoubleClickContext.
 * 
 * @noinstantiate This class is not intended to be instantiated by clients.
 * @noextend This class is not intended to be subclassed by clients.
 */
public class DoubleClickContext extends CustomContext implements IDoubleClickContext {

	/**
	 * Instantiates a new double click context.
	 * 
	 * @param pictogramElement
	 *            the pictogram element
	 * @param innerPictogramElement
	 *            the inner pictogram element
	 * @param innerGraphicsAlgorithm
	 *            the inner graphics algorithm
	 */
	public DoubleClickContext(PictogramElement pictogramElement, PictogramElement innerPictogramElement,
			GraphicsAlgorithm innerGraphicsAlgorithm) {
		super(new PictogramElement[] { pictogramElement });
		setInnerPictogramElement(innerPictogramElement);
		setInnerGraphicsAlgorithm(innerGraphicsAlgorithm);
	}

}
