/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.ArrayList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.internal.editor.DiagramEditorInternal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class GraphitiScrollingGraphicalViewer
extends ScrollingGraphicalViewer {
    private DiagramEditorInternal diagramEditor;

    public GraphitiScrollingGraphicalViewer(DiagramEditorInternal diagramEditor) {
        this.setDiagramEditor(diagramEditor);
    }

    public void select(EditPart editpart) {
        IToolBehaviorProvider tbp = this.getDiagramEditor().getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        boolean connectionPossible = tbp.isConnectionSelectionEnabled();
        if (connectionPossible) {
            super.select(editpart);
            return;
        }
        Object model = editpart.getModel();
        if (!(model instanceof Connection)) {
            super.select(editpart);
            return;
        }
    }

    public void setSelection(ISelection newSelection) {
        IToolBehaviorProvider tbp = this.getDiagramEditor().getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        boolean multiPossible = tbp.isMultiSelectionEnabled();
        boolean connectionPossible = tbp.isConnectionSelectionEnabled();
        if (multiPossible && connectionPossible) {
            super.setSelection(newSelection);
            return;
        }
        if (multiPossible && !connectionPossible) {
            boolean change = false;
            ArrayList<Object> l = new ArrayList<Object>();
            if (newSelection instanceof IStructuredSelection) {
                IStructuredSelection strSel = (IStructuredSelection)newSelection;
                int i = 0;
                while (i < strSel.toArray().length) {
                    EditPart editpart;
                    Object o = strSel.toArray()[i];
                    if (o instanceof EditPart && (editpart = (EditPart)o).getModel() instanceof Connection) {
                        change = true;
                    } else {
                        l.add(o);
                    }
                    ++i;
                }
            }
            if (change) {
                newSelection = new StructuredSelection(l);
            }
            super.setSelection(newSelection);
            return;
        }
        if (!multiPossible && connectionPossible) {
            if (newSelection instanceof IStructuredSelection) {
                IStructuredSelection strSel = (IStructuredSelection)newSelection;
                int i = 0;
                while (i < strSel.toArray().length) {
                    Object o = strSel.toArray()[i];
                    if (o instanceof EditPart) {
                        EditPart ep = (EditPart)o;
                        this.select(ep);
                        return;
                    }
                    ++i;
                }
                this.deselectAll();
            }
            return;
        }
        if (!multiPossible && !connectionPossible) {
            if (newSelection instanceof IStructuredSelection) {
                IStructuredSelection strSel = (IStructuredSelection)newSelection;
                int i = 0;
                while (i < strSel.toArray().length) {
                    EditPart ep;
                    Object o = strSel.toArray()[i];
                    if (o instanceof EditPart && !((ep = (EditPart)o).getModel() instanceof Connection)) {
                        this.select(ep);
                        return;
                    }
                    ++i;
                }
                this.deselectAll();
            }
            return;
        }
    }

    public void appendSelection(EditPart editpart) {
        IToolBehaviorProvider tbp = this.getDiagramEditor().getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        boolean multiPossible = tbp.isMultiSelectionEnabled();
        boolean connectionPossible = tbp.isConnectionSelectionEnabled();
        if (multiPossible && connectionPossible) {
            super.appendSelection(editpart);
            return;
        }
        if (multiPossible && !connectionPossible) {
            Object model = editpart.getModel();
            if (model instanceof Connection) {
                return;
            }
            super.appendSelection(editpart);
            return;
        }
        if (!multiPossible && connectionPossible) {
            this.deselectAll();
            super.appendSelection(editpart);
            return;
        }
        if (!multiPossible && !connectionPossible) {
            Object model = editpart.getModel();
            if (model instanceof Connection) {
                return;
            }
            this.deselectAll();
            super.appendSelection(editpart);
            return;
        }
    }

    private void setDiagramEditor(DiagramEditorInternal diagramEditor) {
        this.diagramEditor = diagramEditor;
    }

    protected DiagramEditorInternal getDiagramEditor() {
        return this.diagramEditor;
    }
}

