/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.parts.IAnchorEditPart;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;
import org.eclipse.graphiti.ui.internal.parts.PictogramElementDelegate;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFChopboxAnchor;

public abstract class AnchorEditPart
extends AbstractGraphicalEditPart
implements IAnchorEditPart,
NodeEditPart {
    private ConnectionAnchor connectionAnchor;
    protected IPictogramElementDelegate delegate;

    public AnchorEditPart(IConfigurationProvider configurationProvider, Anchor anchor) {
        this.setModel(anchor);
        this.delegate = new PictogramElementDelegate(configurationProvider, (PictogramElement)anchor, (EditPart)this);
    }

    public void activate() {
        super.activate();
        this.delegate.activate();
    }

    protected IFigure createFigure() {
        IFigure figure = this.delegate.createFigure();
        this.connectionAnchor = new GFChopboxAnchor(figure);
        return figure;
    }

    public void deactivate() {
        this.delegate.deactivate();
        super.deactivate();
    }

    @Override
    public IConfigurationProvider getConfigurationProvider() throws IllegalStateException {
        return this.delegate.getConfigurationProvider();
    }

    @Override
    public List<Connection> getModelSourceConnections() {
        Anchor anchor = (Anchor)this.getModel();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (anchor != null) {
            connections.addAll((Collection<Connection>)anchor.getOutgoingConnections());
        }
        return connections;
    }

    @Override
    public List<Connection> getModelTargetConnections() {
        Anchor anchor = (Anchor)this.getModel();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (anchor != null) {
            connections.addAll((Collection<Connection>)anchor.getIncomingConnections());
        }
        return connections;
    }

    @Override
    public PictogramElement getPictogramElement() {
        return this.delegate.getPictogramElement();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.connectionAnchor;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.connectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.connectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.connectionAnchor;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.delegate.refreshFigureForEditPart();
        this.getFigure().setVisible(this.getPictogramElement().isVisible());
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.delegate.refreshEditPartsForModelChildrenAndSourceConnections((EditPart)this);
    }

    @Override
    public List<PictogramElement> getModelChildren() {
        return new ArrayList<PictogramElement>();
    }

    public Object getAdapter(Class key) {
        Object ret = this.delegate.getAdapter(key);
        if (ret == null) {
            ret = super.getAdapter(key);
        }
        return ret;
    }

    public IFeatureProvider getFeatureProvider() {
        IFeatureProvider ret = null;
        if (this.delegate != null) {
            ret = this.delegate.getFeatureProvider();
        }
        return ret;
    }

    @Override
    public IPictogramElementDelegate getPictogramElementDelegate() {
        return this.delegate;
    }
}

