/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.Arrays;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.ConnectionDragCreationTool;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.internal.features.context.impl.base.PictogramElementContext;
import org.eclipse.graphiti.internal.services.GraphitiInternal;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.BoxRelativeAnchor;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.parts.AnchorEditPart;
import org.eclipse.graphiti.ui.internal.parts.IBoxRelativeAnchorEditPart;
import org.eclipse.graphiti.ui.internal.util.gef.MultiCreationFactory;

public class BoxRelativeAnchorEditPart
extends AnchorEditPart
implements IBoxRelativeAnchorEditPart {
    public BoxRelativeAnchorEditPart(IConfigurationProvider configurationProvider, BoxRelativeAnchor anchor) {
        super(configurationProvider, (Anchor)anchor);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createModelObjectDeleteEditPolicy(this.getConfigurationProvider()));
        this.installEditPolicy("GraphicalNodeEditPolicy", this.getConfigurationProvider().getEditPolicyFactory().createConnectionEditPolicy());
    }

    public DragTracker getDragTracker(Request request) {
        PictogramElementContext context = new PictogramElementContext(this.getPictogramElement());
        IFeature[] dragAndDropFeatures = this.getConfigurationProvider().getDiagramTypeProvider().getFeatureProvider().getDragAndDropFeatures((IPictogramElementContext)context);
        if (dragAndDropFeatures == null || dragAndDropFeatures.length == 0) {
            return super.getDragTracker(request);
        }
        ConnectionDragCreationTool tool = new ConnectionDragCreationTool(){

            protected boolean handleCreateConnection() {
                Command endCommand = this.getCommand();
                this.setCurrentCommand(endCommand);
                this.executeCurrentCommand();
                this.eraseSourceFeedback();
                return true;
            }
        };
        tool.setFactory((CreationFactory)new MultiCreationFactory(Arrays.asList(dragAndDropFeatures)));
        return tool;
    }

    public boolean showOnDemand() {
        return GraphitiInternal.getEmfService().isObjectAlive((EObject)this.getPictogramElement()) && Graphiti.getPeService().getProperty((PropertyContainer)this.getPictogramElement(), "SHOWONDEMAND") != null;
    }

    @Override
    protected IFigure createFigure() {
        if (!this.showOnDemand()) {
            return super.createFigure();
        }
        IFigure theFigure = super.createFigure();
        theFigure.setVisible(false);
        return theFigure;
    }

    @Override
    protected void refreshVisuals() {
        if (this.showOnDemand()) {
            this.delegate.refreshFigureForEditPart();
            this.getFigure().setVisible(false);
        } else {
            super.refreshVisuals();
        }
    }

    @Override
    public IFeatureProvider getFeatureProvider() {
        IFeatureProvider ret = null;
        if (this.delegate != null) {
            ret = this.delegate.getFeatureProvider();
        }
        return ret;
    }
}

