/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.RelativeLocator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProvider;
import org.eclipse.graphiti.ui.internal.util.draw2d.GFHandleHelper;

public class ZoomingRelativeHandleLocator
extends RelativeLocator
implements Locator {
    private IFigure reference;
    private IConfigurationProvider configurationProvider;
    private Dimension handleDimension;

    public ZoomingRelativeHandleLocator(IFigure reference, IConfigurationProvider configurationProvider, int location, Dimension handleDimension, Dimension handleInsets) {
        this(reference, location, handleInsets);
        this.configurationProvider = configurationProvider;
        this.handleDimension = handleDimension;
    }

    private ZoomingRelativeHandleLocator(IFigure reference, int location, Dimension handleInsets) {
        super(reference, location);
        this.reference = reference;
        switch (location & 5) {
            case 1: {
                break;
            }
        }
        switch (location & 0x18) {
            case 8: {
                break;
            }
        }
    }

    protected Rectangle getReferenceBox() {
        Rectangle result = this.reference instanceof HandleBounds ? ((HandleBounds)this.reference).getHandleBounds() : this.reference.getBounds();
        return result;
    }

    public void relocate(IFigure target) {
        double zoom = GFHandleHelper.getZoomLevel(this.configurationProvider);
        Dimension zoomedTargetDimension = this.handleDimension.getCopy();
        if (zoom != 1.0) {
            zoomedTargetDimension = this.handleDimension.getCopy().scale(zoom);
        }
        Dimension preferredSize = target.getPreferredSize();
        preferredSize.width = zoomedTargetDimension.width;
        preferredSize.height = zoomedTargetDimension.height;
        target.setPreferredSize(preferredSize);
        super.relocate(target);
    }
}

