/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.internal.services.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.styles.Font;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IMigrationService;

public class MigrationServiceImpl
implements IMigrationService {
    @Override
    public void migrate070To080(Diagram d) {
        HashMap<Font, ArrayList<EObject>> fontToUser = new HashMap<Font, ArrayList<EObject>>();
        Resource eResource = d.eResource();
        TreeIterator allContents = eResource.getAllContents();
        while (allContents.hasNext()) {
            Font font;
            EObject eObject = (EObject)allContents.next();
            if (eObject instanceof AbstractText) {
                AbstractText t = (AbstractText)eObject;
                font = t.getFont();
                this.addFontUser(fontToUser, eObject, font);
                continue;
            }
            if (!(eObject instanceof Style)) continue;
            Style s = (Style)eObject;
            font = s.getFont();
            this.addFontUser(fontToUser, eObject, font);
        }
        for (Font font : fontToUser.keySet()) {
            Font newFont = Graphiti.getGaService().manageFont(d, font.getName(), font.getSize(), font.isItalic(), font.isBold());
            ArrayList fontUsers = (ArrayList)fontToUser.get(font);
            for (EObject fontUser : fontUsers) {
                if (fontUser instanceof AbstractText) {
                    ((AbstractText)fontUser).setFont(newFont);
                    continue;
                }
                ((Style)fontUser).setFont(newFont);
            }
        }
    }

    private void addFontUser(Map<Font, ArrayList<EObject>> fontToUser, EObject fontUser, Font font) {
        if (font != null) {
            if (fontToUser.get(font) == null) {
                fontToUser.put(font, new ArrayList());
            }
            fontToUser.get(font).add(fontUser);
        }
    }

    @Override
    public boolean shouldMigrate070To080(Diagram d) {
        HashSet<Font> fonts = new HashSet<Font>();
        Resource eResource = d.eResource();
        TreeIterator allContents = eResource.getAllContents();
        while (allContents.hasNext()) {
            Style s;
            Font font;
            EObject next = (EObject)allContents.next();
            if (next instanceof AbstractText) {
                AbstractText t = (AbstractText)next;
                font = t.getFont();
                if (font == null) continue;
                fonts.add(font);
                continue;
            }
            if (!(next instanceof Style) || (font = (s = (Style)next).getFont()) == null) continue;
            fonts.add(font);
        }
        for (Font font : fonts) {
            if (d.getFonts().contains((Object)font)) continue;
            return true;
        }
        return false;
    }
}

