/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.admin.ui.cloud.internal.ApprovedNodesSection;
import org.eclipse.gyrex.admin.ui.cloud.internal.CloudUiActivator;
import org.eclipse.gyrex.admin.ui.cloud.internal.NodeConnectionSection;
import org.eclipse.gyrex.admin.ui.cloud.internal.OnlineNodesSection;
import org.eclipse.gyrex.admin.ui.cloud.internal.PendingNodesSection;
import org.eclipse.gyrex.admin.ui.configuration.ConfigurationPage;
import org.eclipse.gyrex.admin.ui.internal.forms.FormLayoutFactory;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;

public class CloudConfigurationPage
extends ConfigurationPage {
    final ZooKeeperGate.IConnectionMonitor connectionMonitor = new ZooKeeperGate.IConnectionMonitor(){

        public void connected(ZooKeeperGate gate) {
            CloudConfigurationPage.this.getManagedForm().setInput((Object)CloudUiActivator.getInstance().getCloudManager());
        }

        public void disconnected(ZooKeeperGate gate) {
            CloudConfigurationPage.this.getManagedForm().setInput(null);
        }
    };
    boolean disposed;
    private DataBindingContext bindingContext;

    public CloudConfigurationPage() {
        this.setTitle("Cloud Configuration");
        this.setTitleToolTip("Configure the cloud.");
    }

    protected void createFormContent(IManagedForm managedForm) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout((boolean)true, (int)2));
        Realm realm = SWTObservables.getRealm((Display)Display.getCurrent());
        this.bindingContext = new DataBindingContext(realm);
        NodeConnectionSection connectionSection = new NodeConnectionSection(this, body);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)connectionSection.getSection());
        managedForm.addPart((IFormPart)connectionSection);
        OnlineNodesSection onlineNodesSection = new OnlineNodesSection(body, this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)onlineNodesSection.getSection());
        managedForm.addPart((IFormPart)onlineNodesSection);
        ApprovedNodesSection approvedNodesSection = new ApprovedNodesSection(body, this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)approvedNodesSection.getSection());
        managedForm.addPart((IFormPart)approvedNodesSection);
        PendingNodesSection pendingNodesSection = new PendingNodesSection(body, this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)pendingNodesSection.getSection());
        managedForm.addPart((IFormPart)pendingNodesSection);
        ZooKeeperGate.addConnectionMonitor((ZooKeeperGate.IConnectionMonitor)this.connectionMonitor);
    }

    public void dispose() {
        this.disposed = true;
        this.bindingContext.dispose();
        this.bindingContext = null;
        super.dispose();
        ZooKeeperGate.removeConnectionMonitor((ZooKeeperGate.IConnectionMonitor)this.connectionMonitor);
    }

    public DataBindingContext getBindingContext() {
        if (this.disposed) {
            throw new IllegalStateException("disposed");
        }
        return this.bindingContext;
    }

    public IStatus performSave(IProgressMonitor monitor) {
        return super.performSave(monitor);
    }
}

