/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.jetty.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.http.jetty.admin.ChannelDescriptor;
import org.eclipse.gyrex.http.jetty.admin.ICertificate;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class AddChannelDialog
extends StatusDialog {
    private final StringDialogField idField = new StringDialogField();
    private final StringDialogField portField = new StringDialogField();
    private final SelectionButtonDialogField secureField = new SelectionButtonDialogField(32);
    private final StringDialogField certificateIdField = new StringDialogField();
    private final StringDialogField secureChannelIdField = new StringDialogField();
    private final StringDialogField nodeFilterField = new StringDialogField();
    private final IJettyManager jettyManager;

    public AddChannelDialog(Shell parent, IJettyManager jettyManager) {
        super(parent);
        this.jettyManager = jettyManager;
        this.setTitle("New Connector");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.idField.setLabelText("Id");
        this.portField.setLabelText("Port");
        this.secureField.setLabelText("SSL");
        this.certificateIdField.setLabelText("Certificate");
        this.secureChannelIdField.setLabelText("Secure Connector");
        this.nodeFilterField.setLabelText("Node Filter");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddChannelDialog.this.validate();
            }
        };
        this.idField.setDialogFieldListener(validateListener);
        this.portField.setDialogFieldListener(validateListener);
        this.secureField.setDialogFieldListener(validateListener);
        this.certificateIdField.setDialogFieldListener(validateListener);
        this.secureChannelIdField.setDialogFieldListener(validateListener);
        this.nodeFilterField.setDialogFieldListener(validateListener);
        this.certificateIdField.setContentProposalProcessor(new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<ContentProposal> resultList = new ArrayList<ContentProposal>();
                String patternString = StringUtils.trimToNull((String)StringUtils.substring((String)contents, (int)0, (int)position));
                Collection certificates = AddChannelDialog.this.jettyManager.getCertificates();
                for (ICertificate certificate : certificates) {
                    if (patternString != null && !StringUtils.contains((String)certificate.getId(), (String)patternString)) continue;
                    resultList.add(new ContentProposal(certificate.getId(), certificate.getInfo()));
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        });
        this.secureChannelIdField.setContentProposalProcessor(new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<ContentProposal> resultList = new ArrayList<ContentProposal>();
                String patternString = StringUtils.trimToNull((String)StringUtils.substring((String)contents, (int)0, (int)position));
                Collection channels = AddChannelDialog.this.jettyManager.getChannels();
                for (ChannelDescriptor channel : channels) {
                    if (!channel.isSecure() || patternString != null && !StringUtils.contains((String)channel.getId(), (String)patternString)) continue;
                    resultList.add(new ContentProposal(channel.getId(), String.format("%s (%d)", channel.getId(), channel.toString())));
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        });
        this.secureField.attachDialogField((DialogField)this.certificateIdField);
        Text warning = new Text(composite, 72);
        warning.setText("Warning: this dialog is ugly. Please help us improve the UI. Any mockups and/or patches are very much appreciated!");
        warning.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.idField, this.portField, new Separator(), this.secureField, this.certificateIdField, new Separator(), this.secureChannelIdField, new Separator(), this.nodeFilterField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.idField.getTextControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        return composite;
    }

    private boolean isWithinRange(int port, int lower, int higher) {
        return port >= lower && port <= higher;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            ChannelDescriptor channelDescriptor = new ChannelDescriptor();
            channelDescriptor.setId(this.idField.getText());
            channelDescriptor.setPort(NumberUtils.toInt((String)this.portField.getText()));
            channelDescriptor.setSecure(this.secureField.isSelected());
            channelDescriptor.setCertificateId(StringUtils.trimToNull((String)this.certificateIdField.getText()));
            channelDescriptor.setSecureChannelId(StringUtils.trimToNull((String)this.secureChannelIdField.getText()));
            channelDescriptor.setNodeFilter(StringUtils.trimToNull((String)this.nodeFilterField.getText()));
            this.jettyManager.saveChannel(channelDescriptor);
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            return;
        }
        super.okPressed();
    }

    private void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.http.jetty", message));
        this.getShell().pack(true);
    }

    private void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.http.jetty", message));
    }

    private void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.http.jetty", message));
    }

    void validate() {
        String nodeFilter;
        String id = this.idField.getText();
        if (StringUtils.isNotBlank((String)id) && !IdHelper.isValidId((String)id)) {
            this.setError("The entered connector id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
            return;
        }
        String port = this.portField.getText();
        if (StringUtils.isNotBlank((String)port)) {
            if (!NumberUtils.isDigits((String)port)) {
                this.setError("The entered port is invalid. Please use only digits.");
                return;
            }
            if (!this.isWithinRange(NumberUtils.toInt((String)port), 1, 65535)) {
                this.setError("The entered port is invalid. Port must be within 1 and 65535.");
                return;
            }
        }
        boolean secure = this.secureField.isSelected();
        String certificateId = this.certificateIdField.getText();
        String secureChannelId = this.secureChannelIdField.getText();
        if (secure && StringUtils.isNotBlank((String)certificateId)) {
            if (!IdHelper.isValidId((String)certificateId)) {
                this.setError("The entered certificate id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
                return;
            }
            ICertificate certificate = this.jettyManager.getCertificate(certificateId);
            if (certificate == null) {
                this.setError("The entered certificate id is unknown.");
                return;
            }
        } else if (!secure && StringUtils.isNotBlank((String)secureChannelId)) {
            if (!IdHelper.isValidId((String)secureChannelId)) {
                this.setError("The entered secure connector id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
                return;
            }
            ChannelDescriptor channel = this.jettyManager.getChannel(secureChannelId);
            if (channel == null) {
                this.setError("The entered secure connector is unknown.");
                return;
            }
            if (channel.isSecure()) {
                this.setError("The entered secure connector is not a SSL connector.");
                return;
            }
        }
        if (StringUtils.isNotBlank((String)(nodeFilter = this.nodeFilterField.getText()))) {
            try {
                FrameworkUtil.createFilter((String)nodeFilter);
            }
            catch (InvalidSyntaxException e) {
                this.setError("The entered node filter is invalid. Please use valid LDAP filter syntax. " + e.getMessage());
                return;
            }
        }
        if (StringUtils.isBlank((String)id)) {
            this.setInfo("Please enter a connector id.");
            return;
        }
        if (StringUtils.isBlank((String)port)) {
            this.setInfo("Please enter a port.");
            return;
        }
        if (secure && StringUtils.isBlank((String)certificateId)) {
            this.setInfo("Please enter a certificate id.");
            return;
        }
        if (this.isWithinRange(NumberUtils.toInt((String)port), 1, 1024)) {
            this.setWarning("Ports within 1 and 1024 may require special system privileges.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

