/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.jetty.internal;

import java.util.Collection;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.ImportCertificateDialog;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.JettyConfigurationPage;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.http.jetty.admin.ChannelDescriptor;
import org.eclipse.gyrex.http.jetty.admin.ICertificate;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class CertificatsSection
extends ViewerWithButtonsSectionPart {
    private ListViewer certificatesList;
    private Button addButton;
    private Button removeButton;
    private final DataBindingContext bindingContext;
    private IObservableValue selectedCertificateValue;

    public CertificatsSection(Composite parent, JettyConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("Certificates");
        section.setDescription("Manage the SSL certificates.");
        this.createContent(section);
    }

    void addButtonPressed() {
        ImportCertificateDialog dialog = new ImportCertificateDialog(SwtUtil.getShell((Widget)this.addButton), this.getJettyManager());
        if (dialog.open() == 0) {
            this.markStale();
        }
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    protected void createButtons(Composite parent) {
        this.addButton = this.createButton(parent, "Add...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatsSection.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(parent, "Remove...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificatsSection.this.removeButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.certificatesList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        List list = this.certificatesList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().hint(-1, -1).grab(true, true).create());
        this.certificatesList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.certificatesList.setLabelProvider((IBaseLabelProvider)new CertificatesLabelProvider());
        this.selectedCertificateValue = ViewersObservables.observeSingleSelection((Viewer)this.certificatesList);
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    private IJettyManager getJettyManager() {
        return (IJettyManager)this.getManagedForm().getInput();
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.removeButton), (IObservableValue)SWTObservables.observeSelection((Control)this.certificatesList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public void refresh() {
        Object input = this.getManagedForm().getInput();
        if (input instanceof IJettyManager) {
            IJettyManager jettyManager = (IJettyManager)input;
            Collection certificates = jettyManager.getCertificates();
            this.certificatesList.setInput((Object)certificates);
        }
        super.refresh();
    }

    void removeButtonPressed() {
        ICertificate certificate = (ICertificate)(this.selectedCertificateValue != null ? this.selectedCertificateValue.getValue() : null);
        if (certificate == null) {
            return;
        }
        String certificateId = certificate.getId();
        IJettyManager jettyManager = this.getJettyManager();
        Collection channels = jettyManager.getChannelsUsingCertificate(certificateId);
        if (!channels.isEmpty()) {
            StrBuilder errorMessage = new StrBuilder();
            errorMessage.appendln("Certificate is still in use and cannot be removed.");
            errorMessage.appendln("");
            errorMessage.appendln("Used by:");
            for (ChannelDescriptor channelDescriptor : channels) {
                errorMessage.append("  * ").appendln(channelDescriptor.getId());
            }
            MessageDialog.openError((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Still In Use", (String)errorMessage.toString());
            return;
        }
        if (!MessageDialog.openQuestion((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Remove Certificate", (String)"Do you really want to delete the certificate?")) {
            return;
        }
        jettyManager.removeCertificate(certificateId);
        this.markStale();
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IJettyManager) {
            this.markStale();
            return true;
        }
        return super.setFormInput(input);
    }

    static class CertificatesLabelProvider
    extends LabelProvider {
        CertificatesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ICertificate) {
                ICertificate cert = (ICertificate)element;
                return String.format("%s (%s)", cert.getId(), cert.getInfo());
            }
            return super.getText(element);
        }
    }
}

