/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.http.internal.HttpUiActivator;
import org.eclipse.gyrex.admin.ui.http.internal.HttpUiAdapterFactory;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.ComboDialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.registry.ContextDefinition;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.http.internal.HttpActivator;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddApplicationDialog
extends StatusDialog {
    private final StringDialogField idField = new StringDialogField();
    private final StringDialogField pathField = new StringDialogField();
    private final ComboDialogField providerField = new ComboDialogField(4);
    private final Map<String, String> providerItemToIdMap = new HashMap<String, String>();
    private final ApplicationManager applicationManager;

    public AddApplicationDialog(Shell parent, ApplicationManager applicationManager) {
        super(parent);
        this.applicationManager = applicationManager;
        this.setTitle("New Application");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.idField.setLabelText("Id");
        this.pathField.setLabelText("Context");
        this.providerField.setLabelText("Provider");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddApplicationDialog.this.validate();
            }
        };
        this.idField.setDialogFieldListener(validateListener);
        this.pathField.setDialogFieldListener(validateListener);
        this.providerField.setDialogFieldListener(validateListener);
        this.providerItemToIdMap.clear();
        TreeSet<String> providerItems = new TreeSet<String>();
        Collection providers = HttpActivator.getInstance().getProviderRegistry().getRegisteredProviders().values();
        for (ApplicationProviderRegistration registration : providers) {
            String label = HttpUiAdapterFactory.WORKBENCH_ADAPTER.getLabel((Object)registration);
            this.providerItemToIdMap.put(label, registration.getProviderId());
            providerItems.add(label);
        }
        this.providerField.setItems(providerItems.toArray(new String[providerItems.size()]));
        this.pathField.setContentProposalProcessor(new IContentProposalProvider(){

            public IContentProposal[] getProposals(String contents, int position) {
                ArrayList<ContentProposal> resultList = new ArrayList<ContentProposal>();
                String patternString = StringUtils.trimToNull((String)StringUtils.substring((String)contents, (int)0, (int)position));
                Collection contexts = ContextActivator.getInstance().getContextRegistryImpl().getDefinedContexts();
                for (ContextDefinition contextDefinition : contexts) {
                    if (patternString != null && !StringUtils.contains((String)contextDefinition.getPath().toString(), (String)patternString)) continue;
                    resultList.add(new ContentProposal(contextDefinition.getPath().toString(), contextDefinition.toString()));
                }
                return resultList.toArray(new IContentProposal[resultList.size()]);
            }
        });
        Text warning = new Text(composite, 72);
        warning.setText("Warning: this dialog is ugly. Please help us improve the UI. Any mockups and/or patches are very much appreciated!");
        warning.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.idField, this.providerField, this.pathField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.idField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.providerField.getComboControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.pathField.getTextControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        return composite;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            String id = this.idField.getText();
            String providerId = this.providerItemToIdMap.get(this.providerField.getText());
            String contextPath = this.pathField.getText();
            IRuntimeContext context = ((IRuntimeContextRegistry)HttpUiActivator.getInstance().getService(IRuntimeContextRegistry.class)).get(new Path(contextPath).makeAbsolute().addTrailingSeparator());
            this.applicationManager.register(id, providerId, context, null);
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            return;
        }
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.http", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.http", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.http", message));
    }

    void validate() {
        String id = this.idField.getText();
        if (StringUtils.isBlank((String)id)) {
            this.setInfo("Please enter an id.");
            return;
        }
        if (!IdHelper.isValidId((String)id)) {
            this.setError("The entered id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
            return;
        }
        String providerLabel = this.providerField.getText();
        if (StringUtils.isBlank((String)providerLabel)) {
            this.setInfo("Please select a provider.");
            return;
        }
        String path = this.pathField.getText();
        if (StringUtils.isBlank((String)path)) {
            this.setInfo("Please enter a context path.");
            return;
        }
        if (!Path.EMPTY.isValidPath(path)) {
            this.setError("The entered context path is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_' and '/' as separator.");
            return;
        }
        IRuntimeContextRegistry registry = (IRuntimeContextRegistry)HttpUiActivator.getInstance().getService(IRuntimeContextRegistry.class);
        IRuntimeContext context = registry.get((IPath)new Path(path));
        if (context == null) {
            this.setError("The context is not defined!");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

