/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.jobs.internal;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobLog;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsConfigurationPage;
import org.eclipse.gyrex.admin.ui.jobs.internal.JobsLabelProvider;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class JobsLogSection
extends ViewerWithButtonsSectionPart {
    private Button removeButton;
    private ListViewer dataList;
    private final DataBindingContext bindingContext;
    private IObservableValue selectedValue;

    public JobsLogSection(Composite parent, JobsConfigurationPage page) {
        super(parent, page.getManagedForm().getToolkit(), 512);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("Logs");
        section.setDescription("View logs of recently executed jobs.");
        this.createContent(section);
    }

    protected void createButtons(Composite buttonsPanel) {
        this.removeButton = this.createButton(buttonsPanel, "Remove...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobsLogSection.this.removeButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.dataList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        List list = this.dataList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.dataList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataList.setLabelProvider((IBaseLabelProvider)new JobsLabelProvider());
        this.selectedValue = ViewersObservables.observeSingleSelection((Viewer)this.dataList);
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    JobLog getSelectedValue() {
        return (JobLog)(this.selectedValue != null ? this.selectedValue.getValue() : null);
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.removeButton), (IObservableValue)SWTObservables.observeSelection((Control)this.dataList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public void refresh() {
        ArrayList<JobLog> logs = new ArrayList<JobLog>();
        logs.add(new JobLog("SAP Order Status Sync, 2 minutes ago", false, false));
        logs.add(new JobLog("SAP Order Status Sync, 10 minutes ago", true, false));
        logs.add(new JobLog("Friday Newsletter, 2011-04-01 08:00", false, false));
        logs.add(new JobLog("SAP Order Status Sync, 2011-04-01 06:00", true, false));
        logs.add(new JobLog("AMOS Full Product Load, 2011-04-01 02:00", false, true));
        logs.add(new JobLog("AMOS Full Product Load, 2011-03-31 02:00", false, true));
        this.dataList.setInput(logs);
        super.refresh();
    }

    void removeButtonPressed() {
    }
}

