/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.repositories.IRepositoryDefinitionManager;
import org.eclipse.gyrex.p2.internal.repositories.RepositoryDefinition;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public class AddRepositoryDialog
extends StatusDialog {
    private final StringDialogField idField = new StringDialogField();
    private final StringDialogField uriField = new StringDialogField();
    private final StringDialogField nodeFilterField = new StringDialogField();
    private final IRepositoryDefinitionManager repoManager;

    public AddRepositoryDialog(Shell parent, IRepositoryDefinitionManager repoManager) {
        super(parent);
        this.repoManager = repoManager;
        this.setTitle("New Software Repository");
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.idField.setLabelText("Id");
        this.uriField.setLabelText("URL");
        this.nodeFilterField.setLabelText("Node Filter");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddRepositoryDialog.this.validate();
            }
        };
        this.idField.setDialogFieldListener(validateListener);
        this.nodeFilterField.setDialogFieldListener(validateListener);
        Text warning = new Text(composite, 72);
        warning.setText("Warning: this dialog is ugly. Please help us improve the UI. Any mockups and/or patches are very much appreciated!");
        warning.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.idField, this.uriField, this.nodeFilterField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.idField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.uriField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.nodeFilterField.getTextControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        return composite;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            RepositoryDefinition repository = new RepositoryDefinition();
            repository.setId(this.idField.getText());
            repository.setLocation(new URI(this.uriField.getText()));
            repository.setNodeFilter(StringUtils.trimToNull((String)this.nodeFilterField.getText()));
            this.repoManager.saveRepository(repository);
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            return;
        }
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.p2", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.p2", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.p2", message));
    }

    void validate() {
        String nodeFilter;
        String id = this.idField.getText();
        if (StringUtils.isNotBlank((String)id) && !IdHelper.isValidId((String)id)) {
            this.setError("The entered connector id is invalid. It may only contain ASCII chars a-z, 0-9, '.', '-' and/or '_'.");
            return;
        }
        String uri = this.uriField.getText();
        if (StringUtils.isNotBlank((String)uri)) {
            try {
                new URI(uri);
            }
            catch (URISyntaxException e) {
                this.setError("The entered URL. Please use valid URI syntax. " + e.getMessage());
                return;
            }
        }
        if (StringUtils.isNotBlank((String)(nodeFilter = this.nodeFilterField.getText()))) {
            try {
                FrameworkUtil.createFilter((String)nodeFilter);
            }
            catch (InvalidSyntaxException e) {
                this.setError("The entered node filter is invalid. Please use valid LDAP filter syntax. " + e.getMessage());
                return;
            }
        }
        if (StringUtils.isBlank((String)id)) {
            this.setInfo("Please enter a repository id.");
            return;
        }
        if (StringUtils.isBlank((String)uri)) {
            this.setInfo("Please enter a repository URL.");
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }
}

