/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiDebug;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class P2UiActivator
extends BaseBundleActivator {
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.admin.ui.p2";
    private static volatile P2UiActivator instance;
    private final AtomicReference<ImageRegistry> imageRegistryRef = new AtomicReference();

    public static P2UiActivator getInstance() {
        P2UiActivator activator = instance;
        if (activator == null) {
            throw new IllegalArgumentException("inactive");
        }
        return activator;
    }

    public P2UiActivator() {
        super(SYMBOLIC_NAME);
    }

    private void createImageDescriptor(String id, ImageRegistry reg) {
        URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path("$nl$/icons/" + id), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(id, desc);
    }

    protected void doStart(BundleContext context) throws Exception {
        instance = this;
    }

    protected void doStop(BundleContext context) throws Exception {
        instance = null;
        ImageRegistry imageRegistry = this.imageRegistryRef.getAndSet(null);
        if (imageRegistry != null) {
            imageRegistry.dispose();
        }
    }

    protected Class getDebugOptions() {
        return P2UiDebug.class;
    }

    public ImageRegistry getImageRegistry() {
        ImageRegistry imageRegistry = this.imageRegistryRef.get();
        if (imageRegistry != null) {
            return imageRegistry;
        }
        ImageRegistry newRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        if (this.imageRegistryRef.compareAndSet(null, newRegistry)) {
            this.initializeImageRegistry(newRegistry);
        }
        return this.imageRegistryRef.get();
    }

    private void initializeImageRegistry(ImageRegistry reg) {
        this.createImageDescriptor("obj/metadata_repo_obj.gif", reg);
        this.createImageDescriptor("obj/artifact_repo_obj.gif", reg);
        this.createImageDescriptor("obj/iu_obj.gif", reg);
        this.createImageDescriptor("obj/iu_disabled_obj.gif", reg);
        this.createImageDescriptor("obj/iu_update_obj.gif", reg);
        this.createImageDescriptor("obj/iu_patch_obj.gif", reg);
        this.createImageDescriptor("obj/iu_disabled_patch_obj.gif", reg);
        this.createImageDescriptor("obj/category_obj.gif", reg);
        this.createImageDescriptor("obj/profile_obj.gif", reg);
    }
}

