/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.internal.databinding.TrueWhenListSelectionNotEmptyConverter;
import org.eclipse.gyrex.admin.ui.internal.forms.ViewerWithButtonsSectionPart;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.p2.internal.AddRepositoryDialog;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiLabelProvider;
import org.eclipse.gyrex.admin.ui.p2.internal.SoftwareLandingPage;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.repositories.IRepositoryDefinitionManager;
import org.eclipse.gyrex.p2.internal.repositories.RepositoryDefinition;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Section;

public class RepositoriesSection
extends ViewerWithButtonsSectionPart {
    private Button addButton;
    private Button removeButton;
    private ListViewer reposList;
    private final DataBindingContext bindingContext;
    private IObservableValue selectedRepoValue;

    public RepositoriesSection(Composite parent, SoftwareLandingPage page) {
        super(parent, page.getManagedForm().getToolkit(), 384);
        this.bindingContext = page.getBindingContext();
        Section section = this.getSection();
        section.setText("Software Repository");
        section.setDescription("Define the available repositories.");
        this.createContent(section);
    }

    void addButtonPressed() {
        AddRepositoryDialog dialog = new AddRepositoryDialog(SwtUtil.getShell((Widget)this.addButton), this.getRepoManager());
        if (dialog.open() == 0) {
            this.markStale();
        }
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addButton = this.createButton(buttonsPanel, "Add...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoriesSection.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RepositoriesSection.this.removeButtonPressed();
            }
        });
    }

    protected void createViewer(Composite parent) {
        this.reposList = new ListViewer(parent, this.getToolkit().getBorderStyle() | 4 | 0x100 | 0x200);
        List list = this.reposList.getList();
        this.getToolkit().adapt((Control)list, true, true);
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.reposList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.reposList.setLabelProvider((IBaseLabelProvider)new P2UiLabelProvider());
        this.selectedRepoValue = ViewersObservables.observeSingleSelection((Viewer)this.reposList);
    }

    public DataBindingContext getBindingContext() {
        return this.bindingContext;
    }

    IRepositoryDefinitionManager getRepoManager() {
        return P2Activator.getInstance().getRepositoryManager();
    }

    private RepositoryDefinition getSelectedRepo() {
        return (RepositoryDefinition)(this.selectedRepoValue != null ? this.selectedRepoValue.getValue() : null);
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        UpdateValueStrategy modelToTarget = new UpdateValueStrategy();
        modelToTarget.setConverter((IConverter)new TrueWhenListSelectionNotEmptyConverter());
        this.getBindingContext().bindValue((IObservableValue)SWTObservables.observeEnabled((Control)this.removeButton), (IObservableValue)SWTObservables.observeSelection((Control)this.reposList.getControl()), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), modelToTarget);
    }

    public void refresh() {
        this.reposList.setInput((Object)this.getRepoManager().getRepositories());
        super.refresh();
    }

    void removeButtonPressed() {
        RepositoryDefinition repo = this.getSelectedRepo();
        if (repo == null) {
            return;
        }
        if (!MessageDialog.openQuestion((Shell)SwtUtil.getShell((Widget)this.getSection()), (String)"Remove Repository", (String)"Do you really want to delete the repository?")) {
            return;
        }
        this.getRepoManager().removeRepository(repo.getId());
        this.markStale();
    }
}

