/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.configuration;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.gyrex.admin.ui.internal.configuration.ConfigurationPageRegistration;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationPageRegistry
extends EventManager
implements IExtensionChangeHandler {
    private static final ConfigurationPageRegistration[] EMPTY_CHILDREN = new ConfigurationPageRegistration[0];
    private static final String ELEMENT_PAGE = "page";
    private static final String ROOT_ID = "/";
    private static final ConfigurationPageRegistry instance = new ConfigurationPageRegistry();
    private static final String EP_CONFIGURATION_PAGES = "configurationPages";
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationPageRegistry.class);
    private final ConcurrentMap<String, ConfigurationPageRegistration> pages = new ConcurrentHashMap<String, ConfigurationPageRegistration>();
    private volatile Map<String, Set<ConfigurationPageRegistration>> childrenIdsByParentId;

    private static IExtensionPoint getConfigurationPagesExtensionPoint() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.gyrex.admin.ui", EP_CONFIGURATION_PAGES);
        if (extensionPoint == null) {
            throw new IllegalStateException("extension point not found");
        }
        return extensionPoint;
    }

    public static ConfigurationPageRegistry getInstance() {
        return instance;
    }

    private ConfigurationPageRegistry() {
        IExtensionPoint extensionPoint = ConfigurationPageRegistry.getConfigurationPagesExtensionPoint();
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)extensionPoint));
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.addExtension(tracker, extensions[i]);
            ++i;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (StringUtils.equals((String)ELEMENT_PAGE, (String)element.getName())) {
                ConfigurationPageRegistration page = new ConfigurationPageRegistration(element);
                String id = page.getId();
                if (this.pages.putIfAbsent(id, page) == null) {
                    this.rebuildChildrenMappings();
                } else {
                    LOG.warn("Ignoring duplicate configuration page {} contributed by {}", (Object)id, (Object)extension.getContributor().getName());
                }
            }
            ++n2;
        }
    }

    public ConfigurationPageRegistration[] getChildren(ConfigurationPageRegistration page) {
        Map<String, Set<ConfigurationPageRegistration>> mappings = this.childrenIdsByParentId;
        if (mappings == null) {
            return EMPTY_CHILDREN;
        }
        String pageId = page != null ? page.getId() : ROOT_ID;
        Set<ConfigurationPageRegistration> children = mappings.get(pageId);
        return children != null ? children.toArray(new ConfigurationPageRegistration[children.size()]) : EMPTY_CHILDREN;
    }

    public ConfigurationPageRegistration getPage(String id) {
        return (ConfigurationPageRegistration)this.pages.get(id);
    }

    public ConfigurationPageRegistration getParent(ConfigurationPageRegistration page) {
        if (page.getParentId() == null) {
            return null;
        }
        return (ConfigurationPageRegistration)this.pages.get(page.getParentId());
    }

    public boolean hasChildren(ConfigurationPageRegistration page) {
        Map<String, Set<ConfigurationPageRegistration>> mappings = this.childrenIdsByParentId;
        if (mappings == null) {
            return false;
        }
        String pageId = page != null ? page.getId() : ROOT_ID;
        Set<ConfigurationPageRegistration> children = mappings.get(pageId);
        return children != null && !children.isEmpty();
    }

    private void rebuildChildrenMappings() {
        HashMap<String, Set<ConfigurationPageRegistration>> mappings = new HashMap<String, Set<ConfigurationPageRegistration>>();
        Collection values = this.pages.values();
        for (ConfigurationPageRegistration page : values) {
            String parentId;
            String string = parentId = page.getParentId() != null ? page.getParentId() : ROOT_ID;
            if (!mappings.containsKey(parentId)) {
                mappings.put(parentId, new HashSet(1));
            }
            ((Set)mappings.get(parentId)).add(page);
        }
        this.childrenIdsByParentId = mappings;
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            ConfigurationPageRegistration page;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (StringUtils.equals((String)ELEMENT_PAGE, (String)element.getName()) && (page = (ConfigurationPageRegistration)this.pages.remove(id = element.getAttribute("id"))) != null) {
                this.rebuildChildrenMappings();
            }
            ++n2;
        }
    }
}

