/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.configuration;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gyrex.admin.ui.configuration.ConfigurationPage;
import org.eclipse.gyrex.admin.ui.internal.configuration.ConfigurationPanelView;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.Saveable;

public class ConfigurationPageSaveable
extends Saveable {
    private final ConfigurationPage page;
    private final ConfigurationPanelView view;

    public ConfigurationPageSaveable(ConfigurationPanelView view, ConfigurationPage page) {
        this.view = view;
        this.page = page;
    }

    public void doSave(IProgressMonitor monitor) throws CoreException {
        this.view.setBusy(true);
        try {
            this.page.performSave(monitor);
        }
        finally {
            this.view.setBusy(false);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationPageSaveable other = (ConfigurationPageSaveable)((Object)obj);
        return !(this.page == null ? other.page != null : !((Object)((Object)this.page)).equals((Object)other.page));
    }

    public ImageDescriptor getImageDescriptor() {
        Image image = this.page.getTitleImage();
        if (image == null) {
            return null;
        }
        return ImageDescriptor.createFromImage((Image)image);
    }

    public String getName() {
        return this.page.getTitle();
    }

    public String getToolTipText() {
        return this.page.getTitleToolTip();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.page == null ? 0 : ((Object)((Object)this.page)).hashCode());
        return result;
    }

    public boolean isDirty() {
        return this.page.isDirty();
    }
}

