/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.design.managers;

import java.util.ArrayList;
import org.eclipse.gyrex.admin.ui.internal.design.managers.ItemData;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.internal.provisional.action.ToolBarManager2;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ViewToolBarManager
extends ToolBarManager2 {
    private static final String STYLING_VARIANT = "viewToolbar";
    private ItemData[] itemsData;

    public ToolBar createControl(Composite parent) {
        ToolBar toolBar = this.getControl();
        if (!this.toolBarExist() && parent != null) {
            toolBar = super.createControl(parent);
            toolBar.setData("org.eclipse.rwt.themeVariant", (Object)STYLING_VARIANT);
        }
        return toolBar;
    }

    public void update(boolean force) {
        if ((this.isDirty() || force) && this.toolBarExist()) {
            ToolBar toolBar = this.getControl();
            IContributionItem[] items = this.getItems();
            ArrayList<IContributionItem> clean = new ArrayList<IContributionItem>(items.length);
            IContributionItem separator = null;
            int i = 0;
            while (i < items.length) {
                IContributionItem ci = items[i];
                if (ci.isSeparator()) {
                    separator = ci;
                } else {
                    if (separator != null) {
                        if (clean.size() > 0) {
                            clean.add(separator);
                        }
                        separator = null;
                    }
                    clean.add(ci);
                }
                ++i;
            }
            ToolItem[] mi = toolBar.getItems();
            ArrayList<ToolItem> toRemove = new ArrayList<ToolItem>(mi.length);
            int i2 = 0;
            while (i2 < mi.length) {
                Object data;
                if (mi[i2] != null && ((data = mi[i2].getData()) == null || !clean.contains(data) || data instanceof IContributionItem && ((IContributionItem)data).isDynamic())) {
                    toRemove.add(mi[i2]);
                }
                ++i2;
            }
            boolean useRedraw = clean.size() - (mi.length - toRemove.size()) >= 3;
            try {
                if (useRedraw) {
                    toolBar.setRedraw(false);
                }
                int i3 = toRemove.size();
                while (--i3 >= 0) {
                    ToolItem item = (ToolItem)toRemove.get(i3);
                    if (item.isDisposed()) continue;
                    Control ctrl = item.getControl();
                    if (ctrl != null) {
                        item.setControl(null);
                        ctrl.dispose();
                    }
                    item.dispose();
                }
                mi = toolBar.getItems();
                int srcIx = 0;
                int destIx = 0;
                for (IContributionItem src : clean) {
                    IContributionItem dest = srcIx < mi.length ? (IContributionItem)mi[srcIx].getData() : null;
                    if (dest != null && src.equals(dest)) {
                        ++srcIx;
                        ++destIx;
                        continue;
                    }
                    if (dest != null && dest.isSeparator() && src.isSeparator()) {
                        mi[srcIx].setData((Object)src);
                        ++srcIx;
                        ++destIx;
                        continue;
                    }
                    int start = toolBar.getItemCount();
                    src.fill(toolBar, destIx);
                    int newItems = toolBar.getItemCount() - start;
                    int i4 = 0;
                    while (i4 < newItems) {
                        ToolItem item = toolBar.getItem(destIx++);
                        item.setData((Object)src);
                        item.setData("org.eclipse.rwt.themeVariant", (Object)STYLING_VARIANT);
                        ++i4;
                    }
                }
                int i5 = mi.length;
                while (--i5 >= srcIx) {
                    ToolItem item = mi[i5];
                    if (item.isDisposed()) continue;
                    Control ctrl = item.getControl();
                    if (ctrl != null) {
                        item.setControl(null);
                        ctrl.dispose();
                    }
                    item.dispose();
                }
                this.setDirty(false);
                this.updateItemsData();
                this.disposeInvisibleItems();
            }
            finally {
                if (useRedraw) {
                    toolBar.setRedraw(true);
                }
            }
        }
    }

    public ItemData[] getItemsData() {
        return this.itemsData;
    }

    private boolean toolBarExist() {
        ToolBar toolBar = this.getControl();
        return toolBar != null && !toolBar.isDisposed();
    }

    private void updateItemsData() {
        ToolBar toolBar = this.getControl();
        ToolItem[] items = toolBar.getItems();
        this.itemsData = new ItemData[items.length];
        int i = 0;
        while (i < items.length) {
            ItemData data;
            IContributionItem contributionItem = (IContributionItem)items[i].getData();
            this.itemsData[i] = data = new ItemData(contributionItem.getId(), items[i].getText(), items[i].getToolTipText(), items[i].getImage());
            ++i;
        }
    }

    private void disposeInvisibleItems() {
        ToolBar toolBar = this.getControl();
        ToolItem[] items = toolBar.getItems();
        int i = 0;
        while (i < items.length) {
            IContributionItem itemData;
            Object data;
            ToolItem item = items[i];
            if (!item.isDisposed() && (data = item.getData()) instanceof IContributionItem && !(itemData = (IContributionItem)data).isVisible()) {
                Control ctrl = item.getControl();
                if (ctrl != null) {
                    item.setControl(null);
                    ctrl.dispose();
                }
                item.dispose();
            }
            ++i;
        }
    }
}

