/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.tests.internal;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.gyrex.boot.internal.app.ServerApplication;
import org.eclipse.gyrex.boot.tests.internal.Activator;
import org.eclipse.pde.internal.junit.runtime.RemotePluginTestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTestApplication
extends ServerApplication
implements IApplication {
    private static final Logger LOG = LoggerFactory.getLogger(ServerTestApplication.class);

    protected void onApplicationStarted(final Map arguments) {
        Job testRunner = new Job("PDE JUnit Test Runner"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (Boolean.getBoolean("gyrex.preferences.instancebased")) {
                        LOG.warn("Overriding system propert 'gyrex.preferences.instancebased' in order to force ZooKeeper based cloud preferences!");
                        System.setProperty("gyrex.preferences.instancebased", Boolean.FALSE.toString());
                    }
                    long timeout = Long.getLong("gyrex.servertestapp.timeout", 60000L);
                    LOG.info("Waiting {}ms for node to become online...", (Object)timeout);
                    if (!Activator.cloudOnlineWatch.await(timeout, TimeUnit.MILLISECONDS)) {
                        LOG.error("Timeout waiting for ZooKeeper connection.");
                        ServerApplication.shutdown((Throwable)new Exception("Timeout while waiting for node to establish connection with cloud. Unable to initialize cloud environment. Test execution aborted!"));
                        return Status.CANCEL_STATUS;
                    }
                    LOG.info("Executing tests...");
                    RemotePluginTestRunner.main((String[])ServerTestApplication.getApplicationArguments((Map)arguments));
                    LOG.info("Finished executing tests.");
                    ServerApplication.shutdown(null);
                }
                catch (Exception e) {
                    LOG.error("Failed executing tests. Signaling shutdown!", (Throwable)e);
                    ServerApplication.shutdown((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        testRunner.schedule();
    }
}

