/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.internal.roles;

public class ServerRoleDefaultStartOption
implements Comparable<ServerRoleDefaultStartOption> {
    private final String roleId;
    private final Mode mode;
    private final Trigger trigger;
    private final int startLevel;
    private final String nodeFilter;

    ServerRoleDefaultStartOption(String roleId, Mode mode, Trigger trigger, int startLevel, String nodeFilter) {
        this.roleId = roleId;
        this.mode = mode;
        this.trigger = trigger;
        this.startLevel = startLevel;
        this.nodeFilter = nodeFilter;
    }

    @Override
    public int compareTo(ServerRoleDefaultStartOption o) {
        return this.getStartLevel() - o.getStartLevel();
    }

    public String getNodeFilter() {
        return this.trigger == Trigger.ON_CLOUD_CONNECT ? this.nodeFilter : null;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public boolean matches(Mode mode, Trigger trigger) {
        return (this.mode == Mode.ANY || this.mode == mode) && this.trigger == trigger;
    }

    public static enum Mode {
        ANY,
        DEVELOPMENT,
        PRODUCTION;

    }

    public static enum Trigger {
        ON_BOOT,
        ON_CLOUD_CONNECT;

    }
}

