/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.tests.internal.locking;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.cloud.internal.CloudDebug;
import org.eclipse.gyrex.cloud.internal.locking.DurableLockImpl;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.eclipse.gyrex.cloud.services.locking.IDurableLock;
import org.eclipse.gyrex.cloud.services.locking.ILockMonitor;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableLockTests {
    private static final Logger LOG = LoggerFactory.getLogger(DurableLockTests.class);
    private ScheduledExecutorService executorService;

    private Callable<DurableLockImpl> newAcquireLockCall(final DurableLockImpl lock, final long timeout) {
        return new Callable<DurableLockImpl>(){

            @Override
            public DurableLockImpl call() throws Exception {
                lock.acquire(timeout);
                return lock;
            }
        };
    }

    @Before
    public void setUp() throws Exception {
        this.executorService = Executors.newScheduledThreadPool(4);
        CloudDebug.debug = true;
        CloudDebug.zooKeeperLockService = true;
        CloudDebug.zooKeeperGateLifecycle = false;
        CloudDebug.zooKeeperServer = false;
        CloudDebug.nodeMetrics = false;
        CloudDebug.cloudState = false;
    }

    @After
    public void tearDown() throws Exception {
        this.executorService.shutdownNow();
    }

    @Test
    public void testAcquire001() throws Exception {
        String lockId = "test." + ZooKeeperGate.get().getSessionId() + "." + System.currentTimeMillis();
        Future<DurableLockImpl> lock1 = this.executorService.submit(this.newAcquireLockCall(new DurableLockImpl(lockId, null), 0L));
        DurableLockImpl lock = lock1.get(15L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)lock);
        Assert.assertTrue((boolean)lock.isValid());
        lock.release();
        Assert.assertFalse((boolean)lock.isValid());
    }

    @Test
    public void testAcquire002() throws Exception {
        String lockId = "test." + ZooKeeperGate.get().getSessionId() + "." + System.currentTimeMillis();
        DurableLockImpl lock1 = new DurableLockImpl(lockId, null);
        Future<DurableLockImpl> lock1f = this.executorService.submit(this.newAcquireLockCall(lock1, 1000L));
        DurableLockImpl lock1lock = lock1f.get(15L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)lock1lock);
        Assert.assertNotNull((String)"lock1 must have a name at this point", (Object)lock1.getMyLockName());
        Assert.assertTrue((boolean)lock1lock.isValid());
        DurableLockImpl lock2 = new DurableLockImpl(lockId, null);
        Future<DurableLockImpl> lock2f = this.executorService.submit(this.newAcquireLockCall(lock2, 0L));
        try {
            lock2f.get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"timeout expected, call should never succeed");
        }
        catch (TimeoutException timeoutException) {}
        Assert.assertNotNull((String)"lock2 is still waiting so it must have a name", (Object)lock2.getMyLockName());
        DurableLockImpl lock3 = new DurableLockImpl(lockId, null);
        Future<DurableLockImpl> lock3f = this.executorService.submit(this.newAcquireLockCall(lock3, 2000L));
        try {
            lock3f.get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"timeout expected, call should never succeed");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)"timeout expected but wrong exception thrown", (boolean)(e.getCause() instanceof TimeoutException));
            Collection childrenNames = ZooKeeperGate.get().readChildrenNames(IZooKeeperLayout.PATH_LOCKS_DURABLE.append(lockId), null);
            Assert.assertEquals((String)"only two children are allowed for lock node", (int)2, (int)childrenNames.size());
            Assert.assertTrue((String)"lock2 must exist", (boolean)childrenNames.contains(lock1.getMyLockName()));
            Assert.assertTrue((String)"lock2 must exist", (boolean)childrenNames.contains(lock2.getMyLockName()));
            Assert.assertNull((String)"lock3 should not have a lock name anymore", (Object)lock3.getMyLockName());
        }
        lock1lock.release();
        Assert.assertFalse((boolean)lock1lock.isValid());
        DurableLockImpl lock2lock = lock2f.get(10L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)lock2lock);
        Assert.assertTrue((boolean)lock2lock.isValid());
        lock2lock.release();
        Assert.assertFalse((boolean)lock2lock.isValid());
    }

    @Test
    public void testDisconnectAndRecover001() throws Exception {
        String lockId = "test." + ZooKeeperGate.get().getSessionId() + "." + System.currentTimeMillis();
        LOG.info("Durable lock recovery test. Lock: {}", (Object)lockId);
        Future<DurableLockImpl> lock1 = this.executorService.submit(this.newAcquireLockCall(new DurableLockImpl(lockId, null), 0L));
        DurableLockImpl lock = lock1.get(15L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)lock);
        Assert.assertTrue((boolean)lock.isValid());
        LOG.info("Acquired lock 1: {}", (Object)lock);
        String recoveryKey = lock.getRecoveryKey();
        Assert.assertNotNull((Object)recoveryKey);
        final CountDownLatch reconnected = new CountDownLatch(2);
        ZooKeeperGate.addConnectionMonitor((ZooKeeperGate.IConnectionMonitor)new ZooKeeperGate.IConnectionMonitor(){

            public void connected(ZooKeeperGate gate) {
                reconnected.countDown();
            }

            public void disconnected(ZooKeeperGate gate) {
            }
        });
        LOG.info("Shutting down ZooKeeper gate");
        ZooKeeperGate.get().testShutdown();
        Assert.assertFalse((boolean)lock.isValid());
        reconnected.await(20L, TimeUnit.SECONDS);
        LOG.info("Reconnected ZooKeeper gate");
        Assert.assertFalse((boolean)lock.isValid());
        LOG.info("Recovering lock: {}", (Object)lockId);
        DurableLockImpl recoveredLock = new DurableLockImpl(lockId, null);
        recoveredLock.recover(recoveryKey);
        LOG.info("Durable lock recoverd: {}", (Object)recoveredLock);
        Assert.assertTrue((boolean)recoveredLock.isValid());
        Assert.assertNotNull((Object)recoveredLock.getRecoveryKey());
        Assert.assertFalse((String)"recovery keys should be different", (boolean)StringUtils.equals((String)recoveryKey, (String)recoveredLock.getRecoveryKey()));
    }

    @Test
    public void testKill001() throws Exception {
        String lockId = "test." + ZooKeeperGate.get().getSessionId() + "." + System.currentTimeMillis();
        LOG.info("Durable lock recovery test. Lock: {}", (Object)lockId);
        LockMonitorTestHelper lockMonitor = new LockMonitorTestHelper();
        Future<DurableLockImpl> lock1 = this.executorService.submit(this.newAcquireLockCall(new DurableLockImpl(lockId, (ILockMonitor)lockMonitor), 0L));
        DurableLockImpl lock = lock1.get(15L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)lock);
        Assert.assertTrue((boolean)lock.isValid());
        LOG.info("Acquired lock: {}", (Object)lock);
        String recoveryKey = lock.getRecoveryKey();
        Assert.assertNotNull((Object)recoveryKey);
        LOG.info("Deleting lock path in ZooKeeper");
        ZooKeeperGate.get().deletePath(IZooKeeperLayout.PATH_LOCKS_DURABLE.append(lockId).append(lock.getMyLockName()));
        try {
            lockMonitor.lockLostLatch.await(1L, TimeUnit.MINUTES);
        }
        catch (Exception exception) {}
        Assert.assertFalse((String)"lock must be invalid after remote kill", (boolean)lock.isValid());
        LOG.info("Testing tecovering lock: {}", (Object)lockId);
        IDurableLock recoveredLock = new DurableLockImpl(lockId, null).recover(recoveryKey);
        Assert.assertNull((String)"Should not be possible to recover a killed lock", (Object)recoveredLock);
    }

    final class LockMonitorTestHelper
    implements ILockMonitor<IDurableLock> {
        final CountDownLatch lockReleasedLatch = new CountDownLatch(1);
        final CountDownLatch lockLostLatch = new CountDownLatch(1);
        final CountDownLatch lockAcquiredLatch = new CountDownLatch(1);

        LockMonitorTestHelper() {
        }

        public void lockAcquired(IDurableLock lock) {
            this.lockAcquiredLatch.countDown();
        }

        public void lockLost(IDurableLock lock) {
            this.lockLostLatch.countDown();
        }

        public void lockReleased(IDurableLock lock) {
            this.lockReleasedLatch.countDown();
        }
    }
}

