/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.tests.internal.locking;

import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import junit.framework.Assert;
import org.eclipse.gyrex.cloud.internal.locking.ExclusiveLockImpl;
import org.eclipse.gyrex.cloud.internal.zk.IZooKeeperLayout;
import org.eclipse.gyrex.cloud.internal.zk.ZooKeeperGate;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ExclusiveLockTests {
    private ScheduledExecutorService executorService;

    private Callable<ExclusiveLockImpl> newAcquireLockCall(final ExclusiveLockImpl lock, final long timeout) {
        return new Callable<ExclusiveLockImpl>(){

            @Override
            public ExclusiveLockImpl call() throws Exception {
                lock.acquire(timeout);
                return lock;
            }
        };
    }

    @Before
    public void setUp() throws Exception {
        this.executorService = Executors.newScheduledThreadPool(4);
    }

    @After
    public void tearDown() throws Exception {
        this.executorService.shutdownNow();
    }

    @Test
    public void testAcquire001() throws Exception {
        String lockId = "test." + ZooKeeperGate.get().getSessionId() + "." + System.currentTimeMillis();
        Future<ExclusiveLockImpl> lock1 = this.executorService.submit(this.newAcquireLockCall(new ExclusiveLockImpl(lockId, null), 0L));
        ExclusiveLockImpl lock = lock1.get(15L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)lock);
        Assert.assertTrue((boolean)lock.isValid());
        lock.release();
        Assert.assertFalse((boolean)lock.isValid());
    }

    @Test
    public void testAcquire002() throws Exception {
        String lockId = "test." + ZooKeeperGate.get().getSessionId() + "." + System.currentTimeMillis();
        ExclusiveLockImpl lock1 = new ExclusiveLockImpl(lockId, null);
        Future<ExclusiveLockImpl> lock1f = this.executorService.submit(this.newAcquireLockCall(lock1, 1000L));
        ExclusiveLockImpl lock1lock = lock1f.get(15L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)lock1lock);
        Assert.assertNotNull((String)"lock1 must have a name at this point", (Object)lock1.getMyLockName());
        Assert.assertTrue((boolean)lock1lock.isValid());
        ExclusiveLockImpl lock2 = new ExclusiveLockImpl(lockId, null);
        Future<ExclusiveLockImpl> lock2f = this.executorService.submit(this.newAcquireLockCall(lock2, 0L));
        try {
            lock2f.get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"timeout expected, call should never succeed");
        }
        catch (TimeoutException timeoutException) {}
        Assert.assertNotNull((String)"lock2 is still waiting so it must have a name", (Object)lock2.getMyLockName());
        ExclusiveLockImpl lock3 = new ExclusiveLockImpl(lockId, null);
        Future<ExclusiveLockImpl> lock3f = this.executorService.submit(this.newAcquireLockCall(lock3, 2000L));
        try {
            lock3f.get(10L, TimeUnit.SECONDS);
            Assert.fail((String)"timeout expected, call should never succeed");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)"timeout expected but wrong exception thrown", (boolean)(e.getCause() instanceof TimeoutException));
            Collection childrenNames = ZooKeeperGate.get().readChildrenNames(IZooKeeperLayout.PATH_LOCKS_EXCLUSIVE.append(lockId), null);
            Assert.assertEquals((String)"only two children are allowed for lock node", (int)2, (int)childrenNames.size());
            Assert.assertTrue((String)"lock2 must exist", (boolean)childrenNames.contains(lock1.getMyLockName()));
            Assert.assertTrue((String)"lock2 must exist", (boolean)childrenNames.contains(lock2.getMyLockName()));
            Assert.assertNull((String)"lock3 should not have a lock name anymore", (Object)lock3.getMyLockName());
        }
        lock1lock.release();
        Assert.assertFalse((boolean)lock1lock.isValid());
        ExclusiveLockImpl lock2lock = lock2f.get(10L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)lock2lock);
        Assert.assertTrue((boolean)lock2lock.isValid());
        lock2lock.release();
        Assert.assertFalse((boolean)lock2lock.isValid());
    }

    @Test
    public void testDisconnect001() throws Exception {
        String lockId = "test." + ZooKeeperGate.get().getSessionId() + "." + System.currentTimeMillis();
        Future<ExclusiveLockImpl> lock1 = this.executorService.submit(this.newAcquireLockCall(new ExclusiveLockImpl(lockId, null), 0L));
        ExclusiveLockImpl lock = lock1.get(15L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)lock);
        Assert.assertTrue((boolean)lock.isValid());
        final CountDownLatch reconnected = new CountDownLatch(2);
        ZooKeeperGate.addConnectionMonitor((ZooKeeperGate.IConnectionMonitor)new ZooKeeperGate.IConnectionMonitor(){

            public void connected(ZooKeeperGate gate) {
                reconnected.countDown();
            }

            public void disconnected(ZooKeeperGate gate) {
            }
        });
        ZooKeeperGate.get().testShutdown();
        Assert.assertFalse((boolean)lock.isValid());
        reconnected.await(20L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)lock.isValid());
    }
}

